% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableSelection.R, R/summaryBranchGLMVS.R
\name{coef.BranchGLMVS}
\alias{coef.BranchGLMVS}
\alias{coef.summary.BranchGLMVS}
\title{Extract Coefficients}
\usage{
\method{coef}{BranchGLMVS}(object, which = 1, ...)

\method{coef}{summary.BranchGLMVS}(object, which = 1, ...)
}
\arguments{
\item{object}{a \code{BranchGLMVS} or \code{summary.BranchGLMVS} object.}

\item{which}{which models to get coefficients from, the default is the best model. 
Can specify "all" to get coefficients from all of the best models.}

\item{...}{ignored.}
}
\value{
A numeric matrix with the corresponding coefficient estimates.
}
\description{
Extract Coefficients
}
\examples{
Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, 
family = "gaussian", link = "identity")

# Doing branch and bound selection 
VS <- VariableSelection(Fit, type = "branch and bound", metric = "BIC", 
bestmodels = 10, showprogress = FALSE)

## Getting coefficients from best model
coef(VS, which = 1)

## Getting coefficients from all best models
coef(VS, which = "all")

}
