% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blyth.still.casella.R
\name{blyth.still.casella}
\alias{blyth.still.casella}
\title{Blyth-Still-Casella exact binomial confidence intervals}
\usage{
blyth.still.casella(n, X = NULL, alpha = 0.05, digits = 2,
  CIs.init = NULL, additional.info = FALSE)
}
\arguments{
\item{n}{number of trials}

\item{X}{number of successes (optional)}

\item{alpha}{confidence level = 1 - alpha}

\item{digits}{number of significant digits after the decimal point}

\item{CIs.init}{initial confidence intervals from which the refinement procedure begins
(default starts from Clopper-Pearson confidence intervals)}

\item{additional.info}{additional information about the types of interval endpoints and their possible range is provided if TRUE (default = FALSE)}
}
\value{
If \code{X} is specified, the corresponding confidence interval will be returned, otherwise a list of n + 1 confidence intervals will be returned.

If \code{additional.info = FALSE}, only a list of confidence interval(s) will be returned. For any conincidental endpoint, midpoint of its range will be displayed.

If \code{additional.info = TRUE}, the following lists will be returned:

\tabular{ll}{
   \code{CI}                          \tab a list of confidence intervals \cr
   \code{coinc.index}                 \tab indices of coincidental lower endpoints (L.Index) and their corresponding upper endpoints (U.index)\cr
   \code{endpoint.type}               \tab whether the endpoint is coincidental (C) or non-coincidental (NC)\cr
   \code{range}                       \tab range for each endpoint\cr
}
}
\description{
computes the Blyth-Still-Casella exact binomial confidence intervals based on a refining procedure proposed by George Casella (1986).
}
\examples{
# to obtain 95\% CIs for n = 30 and X = 0 to 30
blyth.still.casella(n = 30, alpha = 0.05, digits = 4)

# to obtain 90\% CIs, endpoint types, indices of coincidental enpoints (if any),
# and range of each endpoint for n = 30 and X = 23
blyth.still.casella(n = 30, X = 23, alpha = 0.05, digits = 4, additional.info = TRUE)

# use initial confidence intervals defined by the user instead of Clopper-Pearson CIs
# CIs.input needs to be a (n + 1) x 2 matrix with sufficient coverage
CIs.input <- matrix(c(0,1), nrow = 11, ncol = 2, byrow = TRUE) # start with [0,1] intervals
blyth.still.casella(n = 10, alpha = 0.05, digits = 4, CIs.init = CIs.input, additional.info = TRUE)

# use summary function to see the range for each endpoint
output <- blyth.still.casella(n = 5, alpha = 0.1, digits = 4, additional.info = TRUE)
summary(output)
}
