% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/102-getProt.R
\name{getProt}
\alias{getProt}
\alias{BMgetProt}
\alias{BMgetProtFASTAUinProt}
\alias{BMgetProtSeqUniProt}
\alias{BMgetProtFASTAKEGG}
\alias{BMgetProtSeqKEGG}
\alias{BMgetProtPDBRCSBPDB}
\alias{BMgetProtSeqRCSBPDB}
\title{Retrieve Protein Sequence in various Formats from Databases}
\usage{
BMgetProt(id, from = c("uniprot", "kegg", "pdb"), type = c("fasta",
  "pdb", "aaseq"), parallel = 5)

BMgetProtFASTAUinProt(id, parallel = 5)

BMgetProtSeqUniProt(id, parallel = 5)

BMgetProtFASTAKEGG(id, parallel = 5)

BMgetProtSeqKEGG(id, parallel = 5)

BMgetProtPDBRCSBPDB(id, parallel = 5)

BMgetProtSeqRCSBPDB(id, parallel = 5)
}
\arguments{
\item{id}{A character vector, as the protein ID(s).}

\item{from}{The database, one of \code{'uniprot'}, \code{'kegg'}, \code{'pdb'}.}

\item{type}{The returned protein format, one of \code{fasta}, \code{pdb}, \code{aaseq}.}

\item{parallel}{An integer, the parallel parameter, indicates how many 
process the user would like to use for retrieving 
the data (using RCurl), default is \code{5}. 
For regular cases, we recommend a number less than \code{20}.}
}
\value{
A length of \code{id} character list, each element 
containing the corresponding protein sequence(s) or file(s).
}
\description{
Retrieve Protein Sequence in various Formats from Databases(BMgetDrug)

Retrieve Protein Sequence (FASTA Format) from the UniProt Database(BMgetProt...UinProt)

Retrieve Protein Sequence (FASTA Format) from the KEGG Database(BMgetProt...KEGG)

Retrieve Protein Sequence (PDB Format) from RCSB PDB(BMgetProt...RCSBPDB)
}
\details{
This function retrieves protein sequence in various formats from three databases.

This function retrieves protein sequences (FASTA format) 
from the UniProt database.

This function retrieves protein sequences (FASTA format) 
from the KEGG database.

This function retrieves protein sequences (PDB format) from RCSB PDB.
}
\examples{
\donttest{
# BMgetProt
id = c('P00750', 'P00751', 'P00752')
BMgetProt(id, from = 'uniprot', type = 'aaseq')}

\donttest{
# BMgetProtFASTAUinProt
id = c('P00750', 'P00751', 'P00752')
BMgetProtFASTAUinProt(id)}

\donttest{
# BMgetProtSeqUniProt
id = c('P00750', 'P00751', 'P00752')
BMgetProtSeqUniProt(id)}

\donttest{
#  BMgetProtFASTAKEGG
id = c('hsa:10161', 'hsa:10162')
BMgetProtFASTAKEGG(id)}

\donttest{
# BMgetProtSeqKEG
id = c('hsa:10161', 'hsa:10162')
BMgetProtSeqKEGG(id)}

\donttest{
# BMgetProtPDBRCSBPDB
id = c('4HHB', '4FF9')
BMgetProtPDBRCSBPDB(id)}

\donttest{
# BMgetProtSeqRCSBPDB
id = c('4HHB', '4FF9')
BMgetProtSeqRCSBPDB(id)}

}
\references{
UniProt. \url{https://www.uniprot.org/}

UniProt REST API Documentation. \url{https://www.uniprot.org/faq/28}

UniProt. \url{https://www.uniprot.org/}

UniProt REST API Documentation. \url{https://www.uniprot.org/faq/28}
}
\seealso{
See \code{\link{BMgetDrug}} for retrieving drug molecules 
from five databases.
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>,
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{BMgetProt}
\keyword{BMgetProtFASTAKEGG}
\keyword{BMgetProtFASTAUinProt}
\keyword{BMgetProtPDBRCSBPDB}
\keyword{BMgetProtSeqKEGG}
\keyword{BMgetProtSeqRCSBPDB}
\keyword{BMgetProtSeqUniProt}
\keyword{KEGG}
\keyword{PDB}
\keyword{UniProt}
\keyword{getProt}
