% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/485-extractDrugAP.R
\name{extrDrugAP}
\alias{extrDrugAP}
\title{Calculate the Atom Pair Fingerprints}
\usage{
extrDrugAP(x, descnames = 1024)
}
\arguments{
\item{x}{Object of classe \code{APset} or \code{list} of vectors}

\item{descnames}{Descriptor set to consider for fingerprint encoding. If a single value 
from 1-4096 is provided then the function uses the corresponding number 
of the most frequent atom pairs stored in the \code{apfp} data set provided 
by the package. Alternatively, one can provide here any custom atom pair 
selection in form of a \code{character} vector.}
}
\value{
matrix or character vectors
}
\description{
Calculate the Atom Pair Fingerprints
}
\details{
Generates fingerprints from descriptor vectors such as atom pairs 
stored in \code{APset} or \code{list} containers. The obtained 
fingerprints can be used for structure similarity comparisons, 
searching and clustering. Due to their compact size, computations 
on fingerprints are often more time and memory efficient than on 
their much more complex atom pair counterparts.
}
\examples{

data(sdfbcl)
apbcl <- convSDFtoAP(sdfbcl)
mol <- extrDrugAP(x = apbcl, descnames = 1024)

}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>,
}
\keyword{extrDrugAP}
