% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/400-extractDrugAIO.R
\name{extrDrugAIO}
\alias{extrDrugAIO}
\title{Calculates All the Molecular Descriptors in the BioMedR Package at Once}
\usage{
extrDrugAIO(molecules, silent = TRUE, warn = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process should be 
shown or not, default is \code{TRUE}.}

\item{warn}{Logical. Whether the warning about some descriptors 
need the 3D coordinates should be shown or not after the calculation, 
default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules, 
each column represents one descriptor. 
Currently, this function returns total 293 descriptors 
composed of 48 descriptor types.
}
\description{
Calculates All the Molecular Descriptors in the BioMedR Package at Once
}
\details{
This function calculates all the molecular descriptors 
in the BioMedR package at once.
}
\note{
Note that we need 3-D coordinates of the molecules to calculate 
some of the descriptors, if not provided, these descriptors 
values will be \code{NA}.
}
\examples{
\donttest{
# Load 20 small molecules that have 3D coordinates
sdf = system.file('sysdata/test.sdf', package = 'BioMedR')
mol = readMolFromSDF(sdf)
dat = extrDrugAIO(mol, warn = FALSE)}

}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{extrDrugAIO}
