% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioM2.R
\name{PlotPathFearture}
\alias{PlotPathFearture}
\title{Visualisation of significant pathway-level features}
\usage{
PlotPathFearture(
  BioM2_pathways_obj = NULL,
  pathlistDB = NULL,
  top = 10,
  p.adjust.method = "none",
  begin = 0.1,
  end = 0.9,
  alpha = 0.9,
  option = "C",
  seq = 1
)
}
\arguments{
\item{BioM2_pathways_obj}{Results produced by BioM2(,target='pathways')}

\item{pathlistDB}{A list of pathways with pathway IDs and their corresponding genes ('entrezID' is used).
For details, please refer to ( data("GO2ALLEGS_BP") )}

\item{top}{Number of significant pathway-level features visualised}

\item{p.adjust.method}{p-value adjustment method.(holm", "hochberg", "hommel",
"bonferroni", "BH", "BY","fdr","none")}

\item{begin}{The (corrected) hue in (0,1) at which the color map begins. Detail for scale_fill_viridis().}

\item{end}{The (corrected) hue in (0,1) at which the color map ends. Detail for scale_fill_viridis()}

\item{alpha}{The alpha transparency, a number in (0,1). Detail for scale_fill_viridis()}

\item{option}{A character string indicating the color map option to use. Detail for scale_fill_viridis()}

\item{seq}{Interval of x-coordinate}
}
\value{
a ggplot2 object
}
\description{
Visualisation of significant pathway-level features
}
