% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_bio.R
\name{TreeBiomass}
\alias{TreeBiomass}
\title{TreeBiomass}
\usage{
TreeBiomass(
  data,
  status,
  species,
  dbh,
  ht,
  decay_class = "ignore",
  sp_codes = "4letter",
  units = "metric"
)
}
\arguments{
\item{data}{A dataframe or tibble. Each row must be an observation of an individual tree.}

\item{status}{Must be a character variable (column) in the provided dataframe or tibble. Specifies whether the individual tree is alive (1) or dead (0).}

\item{species}{Must be a character variable (column) in the provided dataframe or tibble. Specifies the species of the individual tree. Must follow four-letter species code or FIA naming conventions (see README file for more detail).}

\item{dbh}{Must be a numeric variable (column) in the provided dataframe or tibble. Provides the diameter at breast height (DBH) of the individual tree in either centimeters or inches.}

\item{ht}{Must be a numeric variable (column) in the provided dataframe or tibble. Provides the height of the individual tree in either meters or feet.}

\item{decay_class}{Default is set to "ignore", indicating that biomass estimates for standing dead trees will not be adjusted for structural decay. It can be set to a character variable (column) in the provided dataframe or tibble. For standing dead trees, the decay class should be 1, 2, 3, 4, or 5 (see README file for more detail). For live trees, the decay class should be NA or 0.}

\item{sp_codes}{Not a variable (column) in the provided dataframe or tibble. Specifies whether the species variable follows the four-letter code or FIA naming convention (see README file for more detail). Must be set to either "4letter" or "fia". The default is set to "4letter".}

\item{units}{Not a variable (column) in the provided dataframe or tibble. Specifies whether the dbh and ht variables were measured using metric (centimeters and meters) or imperial (inches and feet) units. Also specifies whether the results will be given in metric (kilograms) or imperial (US tons) units. Must be set to either "metric" or "imperial". The default is set to "metric".}
}
\value{
The original dataframe, with four new columns. If decay_class is provided, the biomass estimates for standing dead trees will be adjusted for structural decay.
\itemize{
\item stem_bio_kg (or stem_bio_tons): biomass of stem in kilograms (or tons)
\item bark_bio_kg (or bark_bio_tons): biomass of bark in kilograms (or tons)
\item branch_bio_kg (or branch_bio_tons): biomass of branches in kilograms (or tons)
\item total_bio_kg (or total_bio_kg): biomass of tree (stem + bark + branches) in kilograms (or tons)
}
}
\description{
Uses Forest Inventory and Analysis (FIA) Regional Biomass Equations to estimate above-ground stem, bark, and branch tree biomass. The package uses the California equation set and should not be used for data from other regions.
}
\examples{
TreeBiomass(data = bio_demo_data,
            status = "Live",
            species = "SPP",
            dbh = "DBH_CM",
            ht = "HT_M",
            sp_codes = "4letter",
            units = "metric")

TreeBiomass(data = bio_demo_data,
            status = "Live",
            species = "SPP",
            dbh = "DBH_CM",
            ht = "HT_M",
            decay_class = "Decay",
            sp_codes = "4letter",
            units = "metric")

}
