/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.continuous.ConjugateRootTraitPrior;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousRateTransformation;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.preorder.AbstractFullConditionalDistributionDelegate;
import dr.evomodel.treedatalikelihood.preorder.BranchSufficientStatistics;
import dr.evomodel.treedatalikelihood.preorder.MatrixSufficientStatistics;
import dr.evomodel.treedatalikelihood.preorder.NormalSufficientStatistics;
import java.util.ArrayList;
import java.util.List;

public class BranchConditionalDistributionDelegate
extends AbstractFullConditionalDistributionDelegate {
    private static final String NAME_PREFIX = "bcd";

    public BranchConditionalDistributionDelegate(String string, Tree tree, MultivariateDiffusionModel multivariateDiffusionModel, ContinuousTraitPartialsProvider continuousTraitPartialsProvider, ConjugateRootTraitPrior conjugateRootTraitPrior, ContinuousRateTransformation continuousRateTransformation, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate) {
        super(string, tree, multivariateDiffusionModel, continuousTraitPartialsProvider, conjugateRootTraitPrior, continuousRateTransformation, continuousDataLikelihoodDelegate);
    }

    public static String getName(String string) {
        return "bcd." + string;
    }

    @Override
    protected void constructTraits(TreeTraitProvider.Helper helper) {
        TreeTrait<List<BranchSufficientStatistics>> treeTrait = new TreeTrait<List<BranchSufficientStatistics>>(){

            @Override
            public String getTraitName() {
                return BranchConditionalDistributionDelegate.getName(BranchConditionalDistributionDelegate.this.name);
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.BRANCH;
            }

            @Override
            public Class getTraitClass() {
                return List.class;
            }

            @Override
            public List<BranchSufficientStatistics> getTrait(Tree tree, NodeRef nodeRef) {
                assert (BranchConditionalDistributionDelegate.this.tree == tree);
                return BranchConditionalDistributionDelegate.this.getTraitForNode(nodeRef);
            }

            @Override
            public String getTraitString(Tree tree, NodeRef nodeRef) {
                return BranchConditionalDistributionDelegate.formatted((List)this.getTrait(tree, nodeRef));
            }

            @Override
            public boolean getLoggable() {
                return BranchConditionalDistributionDelegate.this.isLoggable();
            }
        };
        helper.addTrait(treeTrait);
    }

    private static String formatted(List<BranchSufficientStatistics> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (BranchSufficientStatistics branchSufficientStatistics : list) {
            stringBuilder.append(branchSufficientStatistics.toVectorizedString()).append(";\t");
        }
        return stringBuilder.toString();
    }

    protected List<BranchSufficientStatistics> getTraitForNode(NodeRef nodeRef) {
        assert (this.simulationProcess != null);
        assert (this.dimPartial > 0);
        assert (this.dimTrait > 0);
        this.simulationProcess.cacheSimulatedTraits(nodeRef);
        int n = nodeRef == null ? this.likelihoodDelegate.getPartialBufferCount() : 1;
        double[] dArray = new double[this.dimPartial * this.numTraits * n];
        double[] dArray2 = new double[this.dimPartial * this.numTraits * n];
        double[] dArray3 = new double[this.dimTrait * this.dimTrait * this.numTraits * n];
        double[] dArray4 = new double[this.dimTrait * n];
        double[] dArray5 = new double[this.dimTrait * this.dimTrait * this.numTraits * n];
        int n2 = nodeRef == null ? -1 : this.likelihoodDelegate.getActiveNodeIndex(nodeRef.getNumber());
        int n3 = nodeRef == null ? -1 : this.likelihoodDelegate.getActiveMatrixIndex(nodeRef.getNumber());
        int n4 = this.likelihoodDelegate.getActivePrecisionIndex(0);
        ArrayList<BranchSufficientStatistics> arrayList = new ArrayList<BranchSufficientStatistics>();
        this.cdi.getPostOrderPartial(n2, dArray);
        if (this.tree.isRoot(nodeRef)) {
            this.cdi.getRootMatrices(this.likelihoodDelegate.getRootProcessDelegate().getPriorBufferIndex(), n4, dArray3, dArray4, dArray5);
        } else {
            this.cdi.getBranchMatrices(n3, n4, dArray3, dArray4, dArray5);
        }
        this.cdi.getPreOrderPartial(n2, dArray2);
        if (nodeRef == null) {
            for (int i = 0; i < this.tree.getNodeCount(); ++i) {
                NodeRef nodeRef2 = this.tree.getNode(i);
                int n5 = this.likelihoodDelegate.getActiveNodeIndex(nodeRef2.getNumber());
                int n6 = this.likelihoodDelegate.getActiveMatrixIndex(nodeRef2.getNumber());
                this.addOneNode(arrayList, dArray, dArray2, dArray3, dArray4, dArray5, n5, n6);
            }
        } else {
            this.addOneNode(arrayList, dArray, dArray2, dArray3, dArray4, dArray5, 0, 0);
        }
        return arrayList;
    }

    private void addOneNode(List<BranchSufficientStatistics> list, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n, int n2) {
        if (this.numTraits > 1) {
            throw new IllegalArgumentException("Not yet implemented");
        }
        list.add(new BranchSufficientStatistics(new NormalSufficientStatistics(dArray, n, this.dimTrait, this.Pd, this.likelihoodDelegate.getPrecisionType()), new MatrixSufficientStatistics(dArray4, dArray3, dArray5, n2, this.dimTrait, this.Pd, this.likelihoodDelegate.getPrecisionType()), new NormalSufficientStatistics(dArray2, n, this.dimTrait, this.Pd, this.likelihoodDelegate.getPrecisionType())));
    }
}

