/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.epidemiology.casetocase.AbstractCase;
import dr.evomodel.epidemiology.casetocase.BranchMapModel;
import dr.evomodel.epidemiology.casetocase.CaseToCaseTreeLikelihood;
import dr.evomodel.epidemiology.casetocase.PartitionedTreeModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class InfectionBranchMovementOperator
extends SimpleMCMCOperator {
    public static final String INFECTION_BRANCH_MOVEMENT_OPERATOR = "infectionBranchMovementOperator";
    private CaseToCaseTreeLikelihood c2cLikelihood;
    private final boolean resampleInfectionTimes;
    private static final boolean DEBUG = false;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String RESAMPLE_INFECTION_TIMES = "resampleInfectionTimes";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newBooleanRule("resampleInfectionTimes", true), new ElementRule(CaseToCaseTreeLikelihood.class)};

        @Override
        public String getParserName() {
            return InfectionBranchMovementOperator.INFECTION_BRANCH_MOVEMENT_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            CaseToCaseTreeLikelihood caseToCaseTreeLikelihood = (CaseToCaseTreeLikelihood)xMLObject.getChild(CaseToCaseTreeLikelihood.class);
            double d = xMLObject.getDoubleAttribute("weight");
            boolean bl = false;
            if (xMLObject.hasAttribute(RESAMPLE_INFECTION_TIMES)) {
                bl = xMLObject.getBooleanAttribute(RESAMPLE_INFECTION_TIMES);
            }
            return new InfectionBranchMovementOperator(caseToCaseTreeLikelihood, d, bl);
        }

        @Override
        public String getParserDescription() {
            return "This operator switches the painting of a random eligible internal node from the painting of one of its children to the painting of the other";
        }

        @Override
        public Class getReturnType() {
            return InfectionBranchMovementOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public InfectionBranchMovementOperator(CaseToCaseTreeLikelihood caseToCaseTreeLikelihood, double d, boolean bl) {
        this.c2cLikelihood = caseToCaseTreeLikelihood;
        this.setWeight(d);
        this.resampleInfectionTimes = bl;
    }

    @Override
    public String getOperatorName() {
        return INFECTION_BRANCH_MOVEMENT_OPERATOR;
    }

    @Override
    public double doOperation() {
        PartitionedTreeModel partitionedTreeModel = this.c2cLikelihood.getTreeModel();
        BranchMapModel branchMapModel = this.c2cLikelihood.getBranchMap();
        int n = MathUtils.nextInt(this.c2cLikelihood.getOutbreak().size());
        AbstractCase abstractCase = this.c2cLikelihood.getOutbreak().getCase(n);
        while (branchMapModel.get(partitionedTreeModel.getRoot().getNumber()) == abstractCase || !abstractCase.wasEverInfected()) {
            n = MathUtils.nextInt(this.c2cLikelihood.getOutbreak().size());
            abstractCase = this.c2cLikelihood.getOutbreak().getCase(n);
        }
        NodeRef nodeRef = partitionedTreeModel.getEarliestNodeInElement(abstractCase);
        double d = this.adjustTree(partitionedTreeModel, nodeRef);
        return d;
    }

    private double adjustTree(PartitionedTreeModel partitionedTreeModel, NodeRef nodeRef) {
        double d;
        boolean bl;
        BranchMapModel branchMapModel = partitionedTreeModel.getBranchMap();
        AbstractCase abstractCase = branchMapModel.get(nodeRef.getNumber());
        AbstractCase abstractCase2 = branchMapModel.get(partitionedTreeModel.getParent(nodeRef).getNumber());
        NodeRef nodeRef2 = partitionedTreeModel.caseMRCA(abstractCase);
        boolean bl2 = nodeRef != nodeRef2;
        boolean bl3 = bl = !partitionedTreeModel.isRootBlockedBy(abstractCase, abstractCase2) || !partitionedTreeModel.isAncestral(partitionedTreeModel.getParent(nodeRef));
        if (bl && bl2) {
            d = MathUtils.nextBoolean() ? this.moveUp(partitionedTreeModel, nodeRef) : this.moveDown(partitionedTreeModel, nodeRef);
        } else if (bl) {
            d = this.moveUp(partitionedTreeModel, nodeRef);
        } else if (bl2) {
            d = this.moveDown(partitionedTreeModel, nodeRef);
        } else {
            return Double.NEGATIVE_INFINITY;
        }
        return d;
    }

    private double moveUp(PartitionedTreeModel partitionedTreeModel, NodeRef nodeRef) {
        Object object;
        BranchMapModel branchMapModel = partitionedTreeModel.getBranchMap();
        AbstractCase abstractCase = branchMapModel.get(nodeRef.getNumber());
        AbstractCase[] abstractCaseArray = branchMapModel.getArrayCopy();
        NodeRef nodeRef2 = partitionedTreeModel.getParent(nodeRef);
        double d = 0.0;
        NodeRef nodeRef3 = nodeRef;
        for (int i = 0; i < partitionedTreeModel.getChildCount(nodeRef2); ++i) {
            if (partitionedTreeModel.getChild(nodeRef2, i) == nodeRef) continue;
            nodeRef3 = partitionedTreeModel.getChild(nodeRef2, i);
        }
        AbstractCase abstractCase2 = branchMapModel.get(nodeRef2.getNumber());
        NodeRef nodeRef4 = partitionedTreeModel.caseMRCA(abstractCase);
        NodeRef nodeRef5 = partitionedTreeModel.caseMRCA(abstractCase2);
        if (this.c2cLikelihood.getTreeModel().isAncestral(nodeRef2)) {
            if (this.resampleInfectionTimes) {
                abstractCase2.setInfectionBranchPosition(MathUtils.nextDouble());
            }
            if ((object = partitionedTreeModel.getParent(nodeRef2)) != null && branchMapModel.get(object.getNumber()) == branchMapModel.get(nodeRef2.getNumber())) {
                for (Integer n : this.c2cLikelihood.getTreeModel().samePartitionElementUpTree(nodeRef2)) {
                    abstractCaseArray[n.intValue()] = branchMapModel.get(nodeRef.getNumber());
                }
                abstractCaseArray[object.getNumber()] = branchMapModel.get(nodeRef.getNumber());
            }
            d += nodeRef == nodeRef4 ? Math.log(0.5) : 0.0;
        } else {
            if (branchMapModel.get(nodeRef3.getNumber()) == branchMapModel.get(nodeRef2.getNumber())) {
                for (Integer n : this.c2cLikelihood.getTreeModel().samePartitionElementDownTree(nodeRef3)) {
                    abstractCaseArray[n.intValue()] = branchMapModel.get(nodeRef.getNumber());
                }
                abstractCaseArray[nodeRef3.getNumber()] = branchMapModel.get(nodeRef.getNumber());
            }
            d += nodeRef == nodeRef4 ? Math.log(0.5) : 0.0;
        }
        abstractCaseArray[nodeRef2.getNumber()] = branchMapModel.get(nodeRef.getNumber());
        branchMapModel.setAll(abstractCaseArray, false);
        if (this.c2cLikelihood.getTreeModel().isAncestral(nodeRef2)) {
            d += nodeRef3 == nodeRef5 ? Math.log(2.0) : 0.0;
        } else {
            object = partitionedTreeModel.getParent(nodeRef2);
            d += partitionedTreeModel.isRootBlockedBy(abstractCase, abstractCase2) && partitionedTreeModel.isAncestral((NodeRef)object) ? Math.log(2.0) : 0.0;
        }
        if (this.resampleInfectionTimes) {
            abstractCase.setInfectionBranchPosition(MathUtils.nextDouble());
        }
        return d;
    }

    private double moveDown(PartitionedTreeModel partitionedTreeModel, NodeRef nodeRef) {
        BranchMapModel branchMapModel = partitionedTreeModel.getBranchMap();
        AbstractCase abstractCase = branchMapModel.get(nodeRef.getNumber());
        AbstractCase abstractCase2 = branchMapModel.get(partitionedTreeModel.getParent(nodeRef).getNumber());
        AbstractCase[] abstractCaseArray = branchMapModel.getArrayCopy();
        double d = 0.0;
        NodeRef nodeRef2 = partitionedTreeModel.getParent(nodeRef);
        NodeRef nodeRef3 = partitionedTreeModel.caseMRCA(abstractCase);
        for (int i = 0; i < partitionedTreeModel.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef4 = partitionedTreeModel.getChild(nodeRef, i);
            if (!this.c2cLikelihood.getTreeModel().isAncestral(nodeRef4)) {
                for (Integer n : this.c2cLikelihood.getTreeModel().samePartitionElementDownTree(nodeRef4)) {
                    abstractCaseArray[n.intValue()] = branchMapModel.get(nodeRef2.getNumber());
                }
                abstractCaseArray[nodeRef4.getNumber()] = branchMapModel.get(nodeRef2.getNumber());
                continue;
            }
            if (nodeRef4 != nodeRef3 || branchMapModel.get(nodeRef4.getNumber()) != branchMapModel.get(nodeRef.getNumber())) continue;
            d += Math.log(2.0);
        }
        d += partitionedTreeModel.isRootBlockedBy(abstractCase, abstractCase2) && partitionedTreeModel.isAncestral(nodeRef2) ? Math.log(0.5) : 0.0;
        if (this.resampleInfectionTimes) {
            abstractCase.setInfectionBranchPosition(MathUtils.nextDouble());
        }
        abstractCaseArray[nodeRef.getNumber()] = branchMapModel.get(nodeRef2.getNumber());
        branchMapModel.setAll(abstractCaseArray, false);
        return d;
    }

    public String getPerformanceSuggestion() {
        return "Not implemented";
    }
}

