/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DynamicalVariable {
    private String name = "variable";
    private List<Double> times = new ArrayList<Double>();
    private List<Double> values = new ArrayList<Double>();
    private double currentTime = 0.0;
    private double currentValue = 0.0;
    private List<Double> storedTimes = new ArrayList<Double>();
    private List<Double> storedValues = new ArrayList<Double>();
    private double storedTime = 0.0;
    private double storedValue = 0.0;

    public DynamicalVariable(String string, double d, double d2) {
        this.name = string;
        this.currentTime = d;
        this.currentValue = d2;
        this.add(this.currentTime, this.currentValue);
    }

    public void add(double d, double d2) {
        Double d3 = new Double(d);
        Double d4 = new Double(d2);
        this.times.add(d3);
        this.values.add(d4);
    }

    public void pushCurrentState() {
        this.add(this.currentTime, this.currentValue);
    }

    public void modCurrentTime(double d) {
        this.currentTime += d;
    }

    public void modCurrentValue(double d) {
        this.currentValue += d;
    }

    public void reset(double d, double d2) {
        this.currentTime = d;
        this.currentValue = d2;
        this.times.clear();
        this.values.clear();
        this.add(this.currentTime, this.currentValue);
    }

    public void store() {
        Double d;
        this.storedTimes.clear();
        for (Double d2 : this.times) {
            d = new Double(d2);
            this.storedTimes.add(d);
        }
        this.storedValues.clear();
        for (Double d2 : this.values) {
            d = new Double(d2);
            this.storedValues.add(d);
        }
        this.storedTime = this.currentTime;
        this.storedValue = this.currentValue;
    }

    public void restore() {
        Double d;
        this.times.clear();
        for (Double d2 : this.storedTimes) {
            d = new Double(d2);
            this.times.add(d);
        }
        this.values.clear();
        for (Double d2 : this.storedValues) {
            d = new Double(d2);
            this.values.add(d);
        }
        this.currentTime = this.storedTime;
        this.currentValue = this.storedValue;
    }

    public int size() {
        return this.times.size();
    }

    public String getName() {
        return this.name;
    }

    public double getTimeAtIndex(int n) {
        return this.times.get(n);
    }

    public double getValueAtIndex(int n) {
        return this.values.get(n);
    }

    public double getValue(double d) {
        double d2 = 0.0;
        Double d3 = new Double(d);
        int n = Collections.binarySearch(this.times, d3);
        if (n >= 0) {
            Double d4 = this.values.get(n);
            d2 = d4;
        } else {
            int n2 = Math.abs(n) - 2;
            int n3 = Math.abs(n) - 1;
            double d5 = this.getTimeAtIndex(n2);
            double d6 = this.getValueAtIndex(n2);
            double d7 = this.getTimeAtIndex(n3);
            double d8 = this.getValueAtIndex(n3);
            d2 = d6 + (d - d5) * ((d8 - d6) / (d7 - d5));
        }
        return d2;
    }

    public double getIntegral(double d, double d2) {
        int n = 0;
        int n2 = 0;
        double d3 = 0.0;
        int n3 = Collections.binarySearch(this.times, new Double(d));
        n = n3 >= 0 ? n3 : Math.abs(n3) - 1;
        n3 = Collections.binarySearch(this.times, new Double(d2));
        n2 = n3 >= 0 ? n3 : Math.abs(n3) - 2;
        d3 += 0.5 * (this.getTimeAtIndex(n) - d) * (this.getValueAtIndex(n) + this.getValue(d));
        for (n3 = n; n3 < n2; ++n3) {
            d3 += 0.5 * (this.getTimeAtIndex(n3 + 1) - this.getTimeAtIndex(n3)) * (this.getValueAtIndex(n3 + 1) + this.getValueAtIndex(n3));
        }
        return d3 += 0.5 * (d2 - this.getTimeAtIndex(n2)) * (this.getValue(d2) + this.getValueAtIndex(n2));
    }

    public double getAverage(double d, double d2) {
        return 0.5 * (this.getValue(d) + this.getValue(d2));
    }

    public void print() {
        System.out.println(this.name);
        for (int i = 0; i < this.size(); ++i) {
            System.out.println(this.times.get(i) + "\t" + this.values.get(i));
        }
    }
}

