/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.speciation;

import dr.evomodel.alloppnet.speciation.AlloppDiploidHistory;
import dr.evomodel.alloppnet.speciation.AlloppLeggedTree;
import dr.evomodel.alloppnet.speciation.AlloppNetworkPriorModel;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesNetworkModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import java.util.ArrayList;

public class AlloppNetworkPrior
extends Likelihood.Abstract {
    AlloppSpeciesNetworkModel asnm;
    AlloppNetworkPriorModel prior;
    double[] numHybsLogL;

    public AlloppNetworkPrior(AlloppNetworkPriorModel alloppNetworkPriorModel, AlloppSpeciesNetworkModel alloppSpeciesNetworkModel) {
        super(alloppNetworkPriorModel);
        this.asnm = alloppSpeciesNetworkModel;
        this.prior = alloppNetworkPriorModel;
        alloppSpeciesNetworkModel.setHybPopModel(alloppNetworkPriorModel.getHybridPopModel());
        int n = alloppSpeciesNetworkModel.getNofDiploids();
        this.numHybsLogL = new double[alloppSpeciesNetworkModel.maxNumberOfHybPopParameters() + 1];
        for (int i = 0; i < this.numHybsLogL.length; ++i) {
            this.numHybsLogL[i] = (double)(-i) * Math.log(7.0 * Math.sqrt(n));
        }
    }

    @Override
    protected boolean getLikelihoodKnown() {
        return false;
    }

    @Override
    protected double calculateLogLikelihood() {
        double d = 0.0;
        d += this.loglikelihoodEvents();
        d += this.loglikeNumHybridizations();
        Parameter parameter = this.asnm.getTipPopValues();
        ParametricDistributionModel parametricDistributionModel = this.prior.getTipPopModel();
        for (int i = 0; i < parameter.getDimension(); ++i) {
            d += parametricDistributionModel.logPdf(parameter.getParameterValue(i));
        }
        Parameter parameter2 = this.asnm.getRootPopValues();
        ParametricDistributionModel parametricDistributionModel2 = this.prior.getRootPopModel();
        for (int i = 0; i < parameter2.getDimension(); ++i) {
            d += parametricDistributionModel2.logPdf(parameter2.getParameterValue(i));
        }
        ParametricDistributionModel parametricDistributionModel3 = this.prior.getHybridPopModel();
        for (int i = 0; i < this.asnm.getNumberOfTetraTrees(); ++i) {
            d += parametricDistributionModel3.logPdf(this.asnm.getOneHybPopValue(i));
        }
        return d;
    }

    private double loglikeNumHybridizations() {
        int n = this.asnm.getNumberOfTetraTrees();
        return this.numHybsLogL[n];
    }

    private double loglikelihoodEvents() {
        double d = this.prior.getRate().getParameterValue(0);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        AlloppDiploidHistory alloppDiploidHistory = this.asnm.getDiploidHistory();
        alloppDiploidHistory.collectInternalAndHybHeights(arrayList);
        int n = this.asnm.getNumberOfTetraTrees();
        for (int i = 0; i < n; ++i) {
            AlloppLeggedTree alloppLeggedTree = this.asnm.getTetraploidTree(i);
            alloppLeggedTree.collectInternalHeights(arrayList);
        }
        double d2 = 0.0;
        for (double d3 : arrayList) {
            d2 += this.logexpPDF(d3, d);
        }
        return d2;
    }

    private double logexpPDF(double d, double d2) {
        return Math.log(d2) - d2 * d;
    }
}

