/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.EmpiricalDistributionData;
import dr.inference.distribution.EmpiricalDistributionLikelihood;
import dr.inference.model.SplineBasis;
import java.util.List;

public class SplineInterpolatedLikelihood
extends EmpiricalDistributionLikelihood {
    private static final double outsideLogDensity = Double.NEGATIVE_INFINITY;
    private SplineBasis splineBasis = null;

    public SplineInterpolatedLikelihood(String string, int n, boolean bl, boolean bl2) {
        super(string, bl, bl2);
    }

    public SplineInterpolatedLikelihood(List<EmpiricalDistributionData> list, int n, boolean bl) {
        super(list, bl);
    }

    @Override
    protected double logPDF(double d, EmpiricalDistributionData empiricalDistributionData) {
        double[] dArray = empiricalDistributionData.values;
        double[] dArray2 = empiricalDistributionData.density;
        int n = dArray.length;
        if (d < dArray[0] || d > dArray[n - 1]) {
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = 0.0;
        for (int i = 1; i < n; ++i) {
            if (!(dArray[i] > d)) continue;
            double d3 = dArray[i] - dArray[i - 1];
            double d4 = dArray2[i] - dArray2[i - 1];
            d2 = dArray2[i] - (dArray[i] - d) / d3 * d4;
            break;
        }
        if (!empiricalDistributionData.densityInLogSpace) {
            d2 = Math.log(d2);
        }
        if (this.inverse) {
            d2 *= -1.0;
        }
        return d2;
    }

    @Override
    protected double gradientLogPdf(double d, EmpiricalDistributionData empiricalDistributionData) {
        double[] dArray = empiricalDistributionData.values;
        double[] dArray2 = empiricalDistributionData.density;
        int n = dArray.length;
        if (d < dArray[0] || d > dArray[n - 1]) {
            return 0.0;
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] > d)) continue;
            double d3 = dArray[i] - dArray[i - 1];
            double d4 = dArray2[i] - dArray2[i - 1];
            d2 = d4 / d3;
            break;
        }
        if (!empiricalDistributionData.densityInLogSpace) {
            throw new RuntimeException("Not yet implemented");
        }
        if (this.inverse) {
            throw new RuntimeException("Not yet implemented");
        }
        return d2;
    }
}

