/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evomodel.operators.AbstractImportanceDistributionOperator;
import dr.evomodel.tree.ConditionalCladeFrequency;
import dr.evomodel.tree.TreeModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

@Deprecated
public class CCPImportanceDistributionOperator
extends AbstractImportanceDistributionOperator {
    public static final String CCP_IMPORTANCE_DISTRIBUTION_OPERATOR = "CCPImportanceDistributionOperator";
    public static XMLObjectParser CCP_IMPORTANCE_DISTRIBUTION_OPERATOR_PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newIntegerRule("samples"), AttributeRule.newIntegerRule("sampleEvery", true), AttributeRule.newDoubleRule("epsilon", true), new ElementRule(TreeModel.class)};

        @Override
        public String getParserName() {
            return CCPImportanceDistributionOperator.CCP_IMPORTANCE_DISTRIBUTION_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            double d = xMLObject.getDoubleAttribute("weight");
            int n = xMLObject.getIntegerAttribute("samples");
            double d2 = 1.0 - Math.pow(0.5, 1.0 / (double)n);
            if (xMLObject.hasAttribute("epsilon")) {
                d2 = xMLObject.getDoubleAttribute("epsilon");
            }
            int n2 = 10;
            if (xMLObject.hasAttribute("sampleEvery")) {
                n2 = xMLObject.getIntegerAttribute("sampleEvery");
            }
            return new CCPImportanceDistributionOperator(treeModel, d, n, n2, d2);
        }

        @Override
        public String getParserDescription() {
            return "This element represents an operator proposing trees from an importance distribution which is created by the conditional clade probabilities.";
        }

        @Override
        public Class getReturnType() {
            return CCPImportanceDistributionOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public CCPImportanceDistributionOperator(TreeModel treeModel, double d, int n, int n2, double d2) {
        super(treeModel, d, n, n2);
        this.probabilityEstimater = new ConditionalCladeFrequency(treeModel, d2);
    }

    public CCPImportanceDistributionOperator(TreeModel treeModel, double d) {
        super(treeModel, d);
        double d2 = 1.0 - Math.pow(0.5, 1.0E-4);
        this.probabilityEstimater = new ConditionalCladeFrequency(treeModel, d2);
    }

    @Override
    public String getOperatorName() {
        return CCP_IMPORTANCE_DISTRIBUTION_OPERATOR;
    }

    @Override
    public String getPerformanceSuggestion() {
        if (this.getAcceptanceProbability() < this.getMinimumGoodAcceptanceLevel()) {
            return "Try to increase the sample size and/or the steps between each sample.";
        }
        return "";
    }
}

