% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.BchronCalibratedDates.R
\name{plot.BchronCalibratedDates}
\alias{plot.BchronCalibratedDates}
\title{Plot calibrated dates from a BchronCalibrate run}
\usage{
\method{plot}{BchronCalibratedDates}(x, withPositions = FALSE,
  pause = FALSE, dateHeight = 30, borderCol = NULL,
  fillCols = rep("gray", length(x)), withHDR = TRUE, hdrCol = "darkgray",
  ...)
}
\arguments{
\item{x}{Output from \code{\link{BchronCalibrate}}}

\item{withPositions}{Whether to plot with positions (i.e. using the position values as the y axis). Default is FALSE in which case it will produce a sequence of plots, one for each calibrated age.}

\item{pause}{Whether to pause between plots or go ahead and create them all}

\item{dateHeight}{The height of the dates in the same units as the positions (e.g. cm). Only relevant if \code{withPositions=TRUE}.}

\item{borderCol}{The colour of the edges of the dates. If \code{NULL} there are no edges drawn}

\item{fillCols}{A vector of colours to fill each date density}

\item{withHDR}{Whether to plot the 95\% highest density region values}

\item{hdrCol}{The colour of the HDR regions}

\item{...}{Other arguments to plot, e.g. axis limits, titles, etc. See \code{\link{par}}.}
}
\description{
Plots calibrated radiocarbon dates from a \code{\link{BchronCalibrate}} run. Has options to plot on a position (usually depth) scale if supplied with the original run
}
\details{
These plots are intended to be pretty basic and used simply for quick information. Users are encouraged to learn the R plotting features to produce publication quality graphics
}
\seealso{
\code{\link{BchronCalibrate}}, \code{\link{Bchronology}}, \code{\link{BchronRSL}}, \code{\link{BchronDensity}}, \code{\link{BchronDensityFast}}
}
