% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliabilityUni.R
\name{strel}
\alias{strel}
\title{Estimate single test reliability coefficients for unidimensional scales}
\usage{
strel(
  data = NULL,
  estimates = c("alpha", "lambda2", "glb", "omega"),
  interval = 0.95,
  n.iter = 1000,
  n.burnin = 50,
  thin = 1,
  n.chains = 3,
  n.boot = 1000,
  cov.mat = NULL,
  n.obs = NULL,
  freq = TRUE,
  Bayes = TRUE,
  para.boot = FALSE,
  item.dropped = FALSE,
  missing = "pairwise",
  omega.freq.method = "cfa",
  omega.int.analytic = TRUE,
  alpha.int.analytic = TRUE,
  callback = function() { }
)
}
\arguments{
\item{data}{The dataset to be analyzed, observations are rows, items are columns}

\item{estimates}{A character vector containing the estimands, we recommend using lambda4
with only a few items due to the computation time}

\item{interval}{A number specifying the uncertainty interval}

\item{n.iter}{A number for the iterations of the Gibbs Sampler}

\item{n.burnin}{A number for the burnin in the Gibbs Sampler}

\item{thin}{A number for the thinning of the MCMC samples}

\item{n.chains}{A number for the chains to run for the MCMC sampling}

\item{n.boot}{A number for the bootstrap samples}

\item{cov.mat}{A covariance matrix can be supplied instead of a dataset,
but number of observations needs to be specified}

\item{n.obs}{A number for the sample observations when a covariance matrix is supplied
and the factor model is calculated}

\item{freq}{A logical for calculating the frequentist estimates}

\item{Bayes}{A logical for calculating the Bayesian estimates}

\item{para.boot}{A logical for calculating the parametric bootstrap, the default is
the non-parametric}

\item{item.dropped}{A logical for calculating the if-item-dropped statistics}

\item{missing}{A string specifying the way to handle missing data,
'listwise' is self-explanatory,
'pairwise' in the Bayesian paradigm means sampling the missing values as additional parameters
from the joint conditional distribution, in the frequentist paradigm this means using
the 'pairwise' covariance matrix and the full information ML method for omega}

\item{omega.freq.method}{A character string for the method of frequentist omega, either "cfa"
(confirmatory factor analysis), or "pfa" (principal factor analysis),
with "pfa" the interval is always bootstrapped}

\item{omega.int.analytic}{A logical for calculating the omega confidence interval analytically,
only works with cfa as the omega.freq.method}

\item{alpha.int.analytic}{A logical for calculating the alpha confidence interval analytically}

\item{callback}{empty function call for external use}
}
\description{
Reported are Bayesian credible intervals
(highest posterior density) and frequentist confidence intervals
(non parametric or parametric bootstrap).
The estimates supported are Cronbach alpha, Guttman's lambda2/4/6, the glb,
and Mcdonald's omega. Beware of lambda4 with many indicators,
the computational effort is considerable.
The glb method uses adjusted code from the 'Rcsdp' package by
'Hector Corrada Bravo', <https://CRAN.R-project.org/package=Rcsdp>.
This process applies a slightly adjusted solving algorithm from the 'CSDP'
library by 'Brian Borchers' <https://github.com/coin-or/Csdp/wiki>,
<doi:10.1080/10556789908805765>, but is wrapped in 'RcppArmadillo'.
Guttman's Lambda-4 method is from 'Benton' (2015)
<doi:10.1007/978-3-319-07503-7_19>. The principal factor analysis (pfa) for a
version of frequentist omega can be found in 'Rencher' (2007) and is described
in 'Schlegel' (2017)
<https://www.r-bloggers.com/2017/03/iterated-principal-factor-method-of-factor-analysis-with-r/>.
The analytic confidence interval of alpha is from
'Bonett' and 'Wright' (2015) <doi:10.1002/job.1960>.
}
\examples{
# note that these are very few iterations just for the example execution,
# you should use the defaults at least
summary(strel(asrm, estimates = "lambda2", n.chains = 2, n.iter = 200, n.boot = 200))
summary(strel(asrm, estimates = "lambda2", item.dropped = TRUE, n.chains = 2,
n.iter = 100, n.boot = 200))


}
\references{
{

\insertRef{Bonett2015}{Bayesrel}

\insertRef{Murphy2007}{Bayesrel}

\insertRef{Lee2007}{Bayesrel}

\insertRef{Pfadt2021Basic}{Bayesrel}

\insertRef{Rencher2002}{Bayesrel}

}
}
