% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesianSetupGenerateParallel.R
\name{generateParallelExecuter}
\alias{generateParallelExecuter}
\title{Factory to generate a parallel executer of an existing function}
\usage{
generateParallelExecuter(fun, parallel = F, parallelOptions = list(variables
  = "all", packages = "all", dlls = NULL))
}
\arguments{
\item{fun}{function to be changed to parallel exectution}

\item{parallel}{should a parallel R cluster be used or not. If set to T, cores will be detected automatically and n-1 of the available n cores of the machine will be used. Alternatively, you can set the number of cores used by hand}

\item{parallelOptions}{list containing three lists. First "packages" determines the R packages necessary to run the likelihood function. Second "variables" the objects in the global envirnment needed to run the likelihood function and third "dlls" the DLLs needed to run the likelihood function (see Details).}
}
\description{
Factory to generate a parallel executer of an existing function
}
\details{
For parallelization, option T means that an automatic parallelization via R is attempted, or "external", in which case it is assumed that the likelihood is already parallelized. In this case it needs to accept a matrix with parameters as columns.
Further you can specify the packages, objects and DLLs that are exported to the cluster. 
By default a copy of your workspace is exported. However, depending on your workspace this can be very inefficient. 

Alternatively you can specify the environments and packages in the likelihood function (e.g. BayesianTools::VSEM() instead of VSEM()).
}
\note{
Can also be used to make functions compatible with library sensitivity
}
\examples{

testDensityMultiNormal <- generateTestDensityMultiNormal()


parDen <- generateParallelExecuter(testDensityMultiNormal)$parallelFun
x = matrix(runif(9,0,1), nrow = 3)
parDen(x)

}
\author{
Florian Hartig
}
