% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_sampsize.R
\name{bayes_power}
\alias{bayes_power}
\title{Determine the 'power' for a Bayesian hypothesis test}
\usage{
bayes_power(
  n,
  h1,
  h2,
  m1,
  m2,
  sd1 = 1,
  sd2 = 1,
  scale = 1000,
  bound1 = 1,
  bound2 = 1/bound1,
  datasets = 1000,
  nsamp = 1000,
  seed = 31
)
}
\arguments{
\item{n}{A number. The sample size}

\item{h1}{A constraint matrix defining H1}

\item{h2}{A constraint matrix defining H2}

\item{m1}{A vector of expected population means under H1}

\item{m2}{A vector of expected populations means under H2
\code{m2} must be of same length as \code{m1}}

\item{sd1}{A vector of standard deviations under H1. Must be a single number (equal
standard deviation under all populations), or a vector of the same length as \code{m1}}

\item{sd2}{A vector of standard deviations under H2. Must be a single number (equal
standard deviation under all populations), or a vector of the same length as \code{m2}}

\item{scale}{A number specifying the prior scale}

\item{bound1}{A number. The boundary above which BF12 favors H1}

\item{bound2}{A number. The boundary below which BF12 favors H2}

\item{datasets}{A number. The number of datasets to compute the error probabilities}

\item{nsamp}{A number. The number of prior or posterior samples to determine the
fit and complexity}

\item{seed}{A number. The random seed to be set}
}
\value{
The Type 1, Type 2, Decision error and Area of Indecision probability and
the median BF12s under H1 and H2
}
\description{
Determine the 'power' for a Bayesian hypothesis test
}
\examples{
# Short example WITH SMALL AMOUNT OF SAMPLES
h1 <- matrix(c(1,-1,0,0,1,-1), nrow= 2, byrow= TRUE)
h2 <- "c"
m1 <- c(.4,.2,0)
m2 <- c(.2,0,.1)
bayes_power(40, h1, h2, m1, m2, datasets = 50, nsamp = 50)
}
