% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation_Based_Calibration.R
\name{Draw_a_simulated_data_set_and_Draw_posterior_samples}
\alias{Draw_a_simulated_data_set_and_Draw_posterior_samples}
\title{Draw a dataset and MCMC samples}
\usage{
Draw_a_simulated_data_set_and_Draw_posterior_samples(
  sd = 5,
  C = 5,
  seed.for.drawing.a.prior.sample = 1111,
  fun = stats::var,
  NI = 259,
  NL = 259,
  initial.seed.for.drawing.a.data = 1234,
  ModifiedPoisson = FALSE,
  PreciseLogLikelihood = TRUE,
  ite = 1111,
  DrawCurve = FALSE
)
}
\arguments{
\item{sd}{Standard Deviation of priors}

\item{C}{No. of Confidence levels}

\item{seed.for.drawing.a.prior.sample}{seed}

\item{fun}{An one dimensional real valued function defined on the parameter space. This is used in the definition of the rank statistics. Generally speaking, the element of the parameter space is a vector, so the function should be defined on vectors. In my model parameter is mean, standard deviation, C thresholds of the latent Gaussian, so this function should be defined on the C+2 dimensional Euclidean space.}

\item{NI}{No. of images}

\item{NL}{No. of Lesions}

\item{initial.seed.for.drawing.a.data}{seed}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}.

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per lesion}},
and model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pairs of TPF per lesion and FPF  \strong{\emph{per lesion}}.

Similarly,

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per image}},
and model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pair of TPF per lesion and FPF  \strong{\emph{per image}}.



For more details, see the author's paper in which I explained \emph{per image} and \emph{per lesion}.
(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  }, now, it is omiited from this package, because the size of vignettes are large.)

If \code{ModifiedPoisson = TRUE},
 then the \emph{False Positive Fraction (FPF)} is defined as follows
 (\eqn{F_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_L}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_L}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_L}, }

  \deqn{ \frac{F_4+F_5}{N_L}, }

   \deqn{ \frac{F_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).
To emphasize its denominator  \eqn{N_L},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per lesion}.


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\emph{False Positive Fraction (FPF)} is given by

\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_I}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_I}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_I}, }

  \deqn{ \frac{F_4+F_5}{N_I}, }

   \deqn{ \frac{F_5}{N_I}, }

where \eqn{N_I} is the number of images (trial).
To emphasize its denominator \eqn{N_I},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per image}.


The model is fitted so that
the estimated FROC curve can be ragraded
 as the expected pairs of   FPF per image and TPF per lesion (\code{ModifiedPoisson = FALSE })

 or as the expected pairs of   FPF per image and TPF per lesion  (\code{ModifiedPoisson = TRUE})

If \code{ModifiedPoisson = TRUE}, then FROC curve means the expected pair of FPF \strong{per lesion} and TPF.

On the other hand, if  \code{ModifiedPoisson = FALSE}, then FROC curve means the expected pair of \strong{FPF per image} and TPF.




So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it uses only per images (trial). Since we can divide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author also developed FROC theory to consider FROC analysis under per signal.
One can see that the FROC curve is rigid with respect to change of a number of images, so, it does not matter whether \code{ModifiedPoisson = TRUE} or \code{FALSE}.
This rigidity of curves means that the number of images is redundant parameter for the FROC trial and
thus the author try to exclude it.


Revised 2019 Dec 8
Revised 2019 Nov 25
Revised 2019 August 28}

\item{PreciseLogLikelihood}{Logical, that is \code{TRUE} or \code{FALSE}. If \code{PreciseLogLikelihood  = TRUE}(default), then Stan calculates the precise log likelihood with target formulation.
If \code{PreciseLogLikelihood  = FALSE}, then Stan calculates the log likelihood by dropping the constant terms in the likelihood function.
In past, I distinct the stan file, one is target formulation and the another is not. But non-target formulation cause some Jacobian warning,
thus I made all stanfile with target formulation when I uploaded to CRAN.
 Thus this variable is now meaningless.}

\item{ite}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{iter}. A positive integer representing  the  number of samples synthesized by Hamiltonian Monte Carlo method,
and, Default = 10000.}

\item{DrawCurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the curve is to be drawn. TRUE or FALSE. If you want to draw the FROC and AFROC curves, then you set \code{DrawCurve =TRUE}, if not then \code{DrawCurve =FALSE}.
The reason why the author make this variable \code{DrawCurve} is that it takes long time in MRMC case to draw curves, and thus Default value is \code{FALSE} in the case of MRMC data.}
}
\value{
Draw.a.prior.sample The Return value of \code{Draw_a_prior_sample}

A dataList and an object of the stanfit S4 class with respect to the dataList
}
\description{
Draw a dataset and MCMC samples.

    1. draw a model parameter from prior distribution,

    2. draw a dataset from the model with the parameter drawn in step 1,

    3. draw a collection of posterior samples for the dataset drawn in step 2.
}
\examples{
\dontrun{

#  Draw a curve for various seeds and various number of confidence levels.
#  Changing the seed, we can draw a parameter from priors and using this sample,
#  we can draw the datasets from our model whose parameters are
#  the priors samples.


#     1. draw a model parameter from prior distribution,
#     2. draw a dataset from the model with the parameter drawn in step 1,
#     3. draw a collection of posterior samples for the dataset drawn in step 2.



 Draw_a_simulated_data_set_and_Draw_posterior_samples(
 seed.for.drawing.a.prior.sample = 1234,
 C=8)

   Draw_a_simulated_data_set_and_Draw_posterior_samples(
 seed.for.drawing.a.prior.sample = 12345,
 C=7)

    Draw_a_simulated_data_set_and_Draw_posterior_samples(
 seed.for.drawing.a.prior.sample = 123456,
 C=6)


    Draw_a_simulated_data_set_and_Draw_posterior_samples(
 seed.for.drawing.a.prior.sample = 1234567,
 C=5)


}# dottest

}
\seealso{
hits_false_alarms_creator_from_thresholds
}
