





#' @title  Hit Rate: parameter of an MRMC model
#' @description A posterior mean of the model parameter for data \code{\link{ddd}} as an example of truth parameter.

#' @name p
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{make_true_parameter_MRMC}
#'
NULL





#' @title  Mean of signal: parameter of an MRMC model
#' @description A posterior mean of the model parameter for data \code{\link{ddd}} as an example of truth parameter.

#' @name mu
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{make_true_parameter_MRMC}
#'
#' @examples
#'
#'
#' #> BayesianFROC::mu
#'
#' #[,1]      [,2]     [,3]      [,4]
#' #[1,] 1.914686 0.7933306 1.526482 0.9543375
#' #[2,] 2.008008 1.2005846 2.081756 1.0197703
#' #[3,] 1.532117 0.5851726 1.513018 0.8879678
#'
#'
#' # [modality, reader]
#'
#'
#'
#'
#'
NULL



#' @title  Standard Deviation: parameter of an MRMC model
#' @description A posterior mean of the model parameter for data \code{\link{ddd}} as an example of truth parameter.
#' @name v
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{make_true_parameter_MRMC}
#'
NULL

#' @title  Threshold: parameter of an MRMC model
#' @description A posterior mean of the model parameter for data \code{\link{ddd}} as an example of truth parameter.
#' @name z
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{make_true_parameter_MRMC}
#'
NULL




#' @title  Threshold: parameter of an MRMC model
#' @description A posterior mean of the model parameter for data \code{\link{ddd}} as an example of truth parameter.
#' @name dz
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{make_true_parameter_MRMC}
#'
NULL







































#' @title  Hit Rate: parameter of an MRMC model
#' @description A posterior mean of the model parameter for data \code{\link{ddd}} as an example of truth parameter.
#' @details Hit Rate data of some MRMC data to use as a default value
#' of the function \code{ hits_creator_from_rate}.
#' This is an array obtained from estimates of some data contained in this package.
#' To simulate a replication of dataset, the default values should be used from an actual values.
#'  Thus the author prepare this data.

#' @name p_truth
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{hits_creator_from_rate}
#'
NULL


#' @title  Mean of signal: parameter of an MRMC model
#' @description A posterior mean of the model parameter for data \code{\link{ddd}} as an example of truth parameter.
#' @details Mean Rate data of some MRMC data to use as a default value
#' of the function \code{ hits_creator_from_rate}.
#' This is an array obtained from estimates of some data contained in this package.
#' To simulate a replication of dataset, the default values should be used from an actual values.
#'  Thus the author prepare this data.

#' @name mu_truth
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{hits_creator_from_rate}
#'
#' @examples
#'
#'
#' #> mu_truth
#' #
#' #         [,1]      [,2]     [,3]      [,4]
#' #[1,] 1.730751 0.8298189 1.334771 0.6386057
#' #[2,] 1.812523 1.1889223 1.883562 0.7185546
#' #[3,] 1.319588 0.6062924 1.248589 0.5458920
#'
#'
#' # [modality, reader]
#'
#'
#'
#'
#'
NULL



#' @title  Standard Deviation: parameter of an MRMC model
#' @description A posterior mean of the model parameter for data \code{\link{ddd}} as an example of truth parameter.
#' @details Standard Deviation Rate data of some MRMC data to use as a default value
#' of the function \code{ hits_creator_from_rate}.
#' This is an array obtained from estimates of some data contained in this package.
#' To simulate a replication of dataset, the default values should be used from an actual values.
#'  Thus the author prepare this data.
#' @name v_truth
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{hits_creator_from_rate}
#'
NULL

#' @title  Threshold : parameter of an MRMC model
#' @description A posterior mean of the model parameter for data \code{\link{ddd}} as an example of truth parameter.
#' @details Threshold Rate data of some MRMC data to use as a default value
#' of the function \code{ hits_creator_from_rate}.
#' This is an array obtained from estimates of some data contained in this package.
#' To simulate a replication of dataset, the default values should be used from an actual values.
#'  Thus the author prepare this data.
#' @name z_truth
#' @docType data
#' @author Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
#' @seealso \code{hits_creator_from_rate}
#'
NULL




