% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_dataset_MRMC.R
\docType{data}
\name{ddddd}
\alias{ddddd}
\title{MRMC; Model \strong{ \emph{ did not }} converge both null model}
\description{
This is a subset of \code{ \link{dd}}
In the past, this model did not converge in the \strong{Model_MRMC.stan},
thus I made the new stan file to get convergence estimates and
 named the stan file \emph{Model_Hiera_OneModalityMultipleReader_TargetFormulation.stan}.
Thus, even if the number of modalityt is 1, we can pool the AUCs over all readers by using this new model.
The author believes this pooling is the most natural, primitive, simple way.



\describe{

\strong{     } \emph{ }

\item{ ddddd$M   }{ \strong{ \emph{ 1  }}  modality   }
\item{ ddddd$C   }{  \strong{ \emph{ 5 }}    Confidence levels }
\item{ ddddd$Q   }{   \strong{ \emph{ 4 }}   readers}
}
}
\details{
The model \strong{ \emph{ did not }} converge both null model and alternative model in 2019 Jun 21.




\strong{Contents of dddd}


 \code{NL}  = 142 (Number of Lesions)

 \code{NI} = 199 (Number of Images)#'




\strong{\emph{ Contents:  }}

 \emph{          Multiple readers and multiple modalities case, i.e., MRMC case   }








---------------------------------------------------------------------------------------------------
\tabular{ccccc}{
 \strong{ModalityID } \tab   \strong{ReaderID }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{q} \tab  \code{ m}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
  -------------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr
1\tab 1\tab 5\tab  0\tab 50\cr
1\tab 1\tab 4\tab  4\tab 30\cr
1\tab 1\tab 3\tab 20\tab 11\cr
1\tab 1\tab 2\tab 29\tab 5\cr
1\tab 1\tab 1\tab 21\tab 1\cr
1\tab 2\tab 5\tab  0\tab 15\cr
1\tab 2\tab 4\tab  0\tab 29\cr
1\tab 2\tab 3\tab  6\tab 29\cr
1\tab 2\tab 2\tab 15\tab 1\cr
1\tab 2\tab 1\tab 22\tab 0\cr
1\tab 3\tab 5\tab  1\tab 39\cr
1\tab 3\tab 4\tab 15\tab 31\cr
1\tab 3\tab 3\tab 18\tab 8\cr
1\tab 3\tab 2\tab 31\tab 10\cr
1\tab 3\tab 1\tab 19\tab 3\cr
1\tab 4\tab 5\tab  1\tab 10\cr
1\tab 4\tab 4\tab  2\tab 8\cr
1\tab 4\tab 3\tab  4\tab 25\cr
1\tab 4\tab 2\tab 16\tab 45\cr
1\tab 4\tab 1\tab 17\tab 14\cr}
---------------------------------------------------------------------------------------------------
}
\examples{


#----------------------------------------------------------------------------------------
#                        Show data by table
#----------------------------------------------------------------------------------------



                        viewdata(BayesianFROC::ddddd)




####1#### ####2#### ####3#### ####4#### ####5#### ####6#### ####7#### ####8#### ####9####
#----------------------------------------------------------------------------------------
#                       make an object dddd from an object dd
#----------------------------------------------------------------------------------------



           ddd  <-  data.frame(m=dd$m,q=dd$q,c=dd$c,h=dd$h,f=dd$f)

           dddd <-  ddd[ddd$m < 2,]  #  Reduce the dataset ddd, i.e., dd

ddd <- list(
           m=dddd$m,
           q=dddd$q,
           c=dddd$c,
           h=dddd$h,
           f=dddd$f,
           NL=142,
           C=max(dddd$c),
           M=max(dddd$m),
           Q=max(dddd$q)
        )

          ddddd <-ddd




\donttest{

#----------------------------------------------------------------------------------------
#                      Pool AUCs over all readers
#----------------------------------------------------------------------------------------


  fit <- fit_Bayesian_FROC(ddddd)

  DrawCurves(fit,readerID = c(1,2,3,4))


#  With pain 2019 Sept 29
}




}
\references{
Example data of Jafroc software
}
\seealso{
\code{\link{dataList.Chakra.Web} }
 \code{\link{dataList.Chakra.Web.orderd} }
  \code{\link{dd} }
}
\author{
Issei Tsunoda \email{tsunoda.issei1111@gmail.com }
}
