% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ApproxMean}
\alias{ApproxMean}
\title{Returns the approximate restricted posterior mean survival for the PLLH model.}
\usage{
ApproxMean(Y, s, lam, J)
}
\arguments{
\item{Y}{Sequence from 0.01 to the maximum observed event time used to compute the approximate restricted mean survival time. Smaller spaced sequences results in better approximation but longer computation time.}

\item{s}{Vector of split points. The first and last entries must be 0 and max(Y).}

\item{lam}{Vector of log-hazard values at each split point location. Must be same length as s.}

\item{J}{Number of split points.}
}
\value{
Returns the approximate restricted posterior mean survival time for the PLLH model.
}
\description{
Uses a grid and parameter values to approximate the restricted posterior mean survival for the PLLH model using the integral of the survival function.
}
\examples{
##Generate Data
Y1=rweibull(100,4,1)
##Create sequence from (0,max(Y1)) for approximation
Y=seq(.01,max(Y1),.01)
##Parameters used to approximate the mean
s=c(0,1,max(Y1))
lam=c(-2,0,-2)
J=1
ApproxMean( Y, s, lam, J)
}
