% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hp.R
\name{plot.HP}
\alias{plot.HP}
\title{HP: Plot the life table}
\usage{
\method{plot}{HP}(
  x,
  age = NULL,
  Ex = NULL,
  plotIC = TRUE,
  plotData = TRUE,
  labels = NULL,
  colors = NULL,
  linetype = NULL,
  prob = 0.95,
  ...
)
}
\arguments{
\item{x}{Object of the class \code{HP} or \code{ClosedHP} returned by hp() or hp_close() functions.}

\item{age}{Vector with the ages to plot the life table.}

\item{Ex}{Vector with the exposures of the selected ages. Its length must be equal to the age vector. This argument is only necessary when using poisson and binomial HP models.}

\item{plotIC}{Logical. If 'TRUE' (default), shows the predictive intervals.}

\item{plotData}{Logical. If 'TRUE' (default), shows crude rate (black dots).}

\item{labels}{Vector with the name of the curve label. (Optional).}

\item{colors}{Vector with the color of the curve. (Optional).}

\item{linetype}{Vector with the line type of the curve. (Optional).}

\item{prob}{Coverage probability of the predictive intervals. Default is '0.95'.}

\item{...}{Other arguments.}
}
\value{
A 'ggplot' object with fitted life table.
}
\description{
Function that returns a log-scale ggplot of \code{HP} and \code{ClosedHP} objects returned by the hp() and hp_close() functions.
}
\examples{
## Selecting the exposure and the death count of the year 1990, ranging from 0 to 90 years old:
USA1990 = USA[USA$Year == 1990,]
x = 0:90
Ex = USA1990$Ex.Male[x+1]
Dx = USA1990$Dx.Male[x+1]

## Fitting the poisson and the lognormal model:
fit = hp(x = x, Ex = Ex, Dx = Dx, model = "poisson",
         M = 2000, bn = 1000, thin = 1)
fit2 = hp(x = x, Ex = Ex, Dx = Dx, model = "lognormal",
          M = 2000, bn = 1000, thin = 1)

## Plot the life tables:
plot(fit)
plot(fit2, age = 0:110, plotIC = TRUE)

## To plot multiples life tables see ?plot.list
plot(list(fit, fit2),
     age = 0:110, Ex = USA1990$Ex.Male,
     plotIC = FALSE, colors = c("red", "blue"),
     labels = c("Poisson", "Lognormal"))

}
\seealso{
\code{\link[=plot.DLM]{plot.DLM()}}, \code{\link[=plot.BLC]{plot.BLC()}} and \code{\link[=plot.PredBLC]{plot.PredBLC()}} for \code{DLM}, \code{BLC} or \code{PredBLC} methods.

\code{\link[=plot.list]{plot.list()}} to the \code{list} method, adding multiple objects in one single plot.

\code{\link[=plot_chain]{plot_chain()}} to plot the chains generated by the MCMC algorithms for the \code{HP} and \code{DLM} objects.
}
