% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/aaClasses.R, R/methods-BFBayesFactor.R, R/methods-BFBayesFactorTop.R
\docType{class}
\name{BFBayesFactor-class}
\alias{*,BFBayesFactor,BFodds-method}
\alias{/,BFBayesFactor,BFBayesFactor-method}
\alias{/,numeric,BFBayesFactor-method}
\alias{BFBayesFactor-class}
\alias{BFBayesFactorTop-class}
\alias{[,BFBayesFactor,index,missing,missing-method}
\alias{[,BFBayesFactorTop,index,missing,missing-method}
\alias{is.na,BFBayesFactor-method}
\alias{t,BFBayesFactor-method}
\alias{which.max,BFBayesFactor-method}
\alias{which.min,BFBayesFactor-method}
\title{General S4 class for representing multiple Bayes factor model comparisons, all against the same model}
\usage{
\S4method{/}{numeric,BFBayesFactor}(e1, e2)

\S4method{/}{BFBayesFactor,BFBayesFactor}(e1, e2)

\S4method{[}{BFBayesFactor,index,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{t}{BFBayesFactor}(x)

\S4method{which.max}{BFBayesFactor}(x)

\S4method{which.min}{BFBayesFactor}(x)

\S4method{is.na}{BFBayesFactor}(x)

\S4method{*}{BFBayesFactor,BFodds}(e1, e2)

\S4method{[}{BFBayesFactorTop,index,missing,missing}(x, i, j, ...,
  drop = TRUE)
}
\arguments{
\item{e1}{Numerator of the ratio}

\item{e2}{Denominator of the ratio}

\item{x}{BFBayesFactor object}

\item{i}{indices indicating elements to extract}

\item{j}{unused for BFBayesFactor objects}

\item{...}{further arguments passed to related methods}

\item{drop}{unused}
}
\description{
The \code{BFBayesFactor} class is a general S4 class for representing models model comparison via Bayes factor.
}
\details{
\code{BFBayesFactor} objects can be inverted by taking the reciprocal and can
   be divided by one another, provided both objects have the same denominator. In addition,
   the \code{t} (transpose) method can be used to invert Bayes factor objects.
  \describe{
  The \code{BFBayesFactor} class has the following slots defined:
   \item{numerator}{a list of models all inheriting \code{BFmodel}, each providing a single denominator}
   \item{denominator}{a single \code{BFmodel} object serving as the denominator for all model comparisons}
   \item{bayesFactor}{a data frame containing information about the comparison between each numerator and the denominator}
   \item{data}{a data frame containing the data used for the comparison}
   \item{version}{character string giving the version and revision number of the package that the model was created in}
   }
}
\examples{
## Compute some Bayes factors to demonstrate division and indexing
data(puzzles)
bfs <- anovaBF(RT ~ shape*color + ID, data = puzzles, whichRandom = "ID", progress=FALSE)

## First and second models can be separated; they remain BFBayesFactor objects
b1 = bfs[1]
b2 = bfs[2]
b1

## We can invert them, or divide them to obtain new model comparisons
1/b1
b1 / b2

## Use transpose to create a BFBayesFactorList
t(bfs)
}

