% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{plot.BayesFBHborrow}
\alias{plot.BayesFBHborrow}
\title{Plot the MCMC results}
\usage{
\method{plot}{BayesFBHborrow}(x, x_lim, estimator = NULL, type = NULL, ...)
}
\arguments{
\item{x}{object of class "BayesFBHborrow" to be visualized}

\item{x_lim}{x-axis to be used for plot}

\item{estimator}{which estimate to be visualized}

\item{type}{The type of plot to be produced, 
"trace" will produce a trace plot of the "fixed" parameters, 
"hist" will give a histogram for the "fixed" parameters, 
and "matrix" will plot the mean and quantiles of a given sample.}

\item{...}{other plotting arguments, see plot_trace(), plot_hist(), plot_matrix()
for more information}
}
\value{
ggplot2 object
}
\description{
S3 object which produces different plots depending on the 
"type" variable
}
\examples{
data(weibull_cc, package = "BayesFBHborrow")

# Set your tuning parameters
tuning_parameters <- list("Jmax" = 5,
                          "pi_b" = 0.5,
                          "cprop_beta" = 0.5)
                          
# run the MCMC sampler
out <- BayesFBHborrow(weibull_cc, NULL, tuning_parameters, 
                      initial_values = NULL,
                      iter = 10, warmup_iter = 1)

# Now let's create a variety of plots

# Staring with a histogram of beta_1 (treatment effect)
gg_hist <- plot(out, NULL, estimator = "beta_1", type = "hist",
                title = "Example histogram of beta_1")

# And an accompanied trace plot of the same parameter                 
gg_trace <- plot(out, 1:10, estimator = "beta_1", type = "trace",
                  title = "Example trace plot", xlab = "iterations",
                  ylab = "beta_1 (treatment effect)")
                  
# Lastly. visualize the smoothed baseline hazard
time_grid <- seq(0, max(weibull_cc$tte), length.out = 2000)
gg_matrix <- plot(out, time_grid, estimator = "out_slam", type = "matrix",
                  title = "Example plot of smoothed baseline hazard",
                  xlab = "time", ylab = "baseline hazard")
}
