% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.study.R
\name{model.study}
\alias{model.study}
\title{Model code of CACE analysis for a single study, or a two-step approach for meta-analysis 
with complete complice information}
\usage{
model.study(re.values = list())
}
\arguments{
\item{re.values}{a list of parameter values for the random effects. It should contain the assignment for these
parameters only: \code{n.m} and \code{n.s}, which refer to the mean and standard deviation used
in the normal distribution estimation of \code{n}, as well as \code{a.m}, \code{a.s}, 
\code{alpha.s.m}, \code{alpha.s.s}, \code{alpha.b.m}, \code{alpha.b.s}, \code{alpha.u.m}, \code{alpha.u.s},
\code{alpha.v.m}, \code{alpha.v.s}. By default, this is an empty list, and all the mean are set to \code{0}, and 
\code{alpha.n.s = alpha.a.s = 0.16}, and \code{alpha.s.s = alpha.b.s = alpha.u.s = alpha.v.s = 0.25}.}
}
\value{
It returns a model string
}
\description{
This function generates the model code for a single study using the 
likelihood and model specified in Section 2.1, or a two-step 
approach for meta-analysis with complete compliance information as 
described in Section 2.2, "The two-step approach" of the package manuscript.
This function will be called internally if user uses the \code{cace.study} function.
}
\examples{
model.string <- model.study()
}
