% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engagements.R
\name{engagements}
\alias{engagements}
\title{Engagements of (spatial) Bayesian brain mapping}
\usage{
engagements(
  bMap,
  u = NULL,
  z = NULL,
  alpha = 0.01,
  type = c(">", "abs >", "<", "!="),
  method_p = "BH",
  verbose = FALSE,
  which.nets = NULL,
  deviation = FALSE
)
}
\arguments{
\item{bMap}{Fitted (spatial) Bayesian brain map from \code{\link{BrainMap}}.}

\item{u, z}{Set a threshold value for engagement? A threshold value can be
specified directly with \code{u}, or a z-score-like threshold in terms of
standard deviations (the SD of values in the mean prior) can be specified
with \code{z}. Only one type of threshold can be used. Default: \code{NULL}
(do not use a threshold). Either argument can also be a vector to test
multiple thresholds at once, as long as \code{type} is not \code{"!="}
(to ensure the engagement regions are successive subsets).}

\item{alpha}{Significance level for hypothesis testing. Default: \code{0.01}.}

\item{type}{Type of region: \code{">"} (default), \code{"abs >"}, \code{"<"},
or \code{"!="}. \code{"abs >"} tests for magnitude by taking the absolute
value and then testing if they are greater than... .}

\item{method_p}{If the input is a \code{"bMap.[format]"} model object, the
type of multiple comparisons correction to use for p-values, or \code{NULL}
for no correction. See \code{help(p.adjust)}. Default: \code{"BH"}
(Benjamini & Hochberg, i.e. the false discovery rate). Note that multiple
comparisons will account for data locations, but not networks.}

\item{verbose}{If \code{TRUE}, display progress of algorithm. Default:
\code{FALSE}.}

\item{which.nets}{Indices of networks for which to identify engagements. If
\code{NULL} (default), use all networks.}

\item{deviation}{If \code{TRUE} identify significant deviations from the
prior mean, rather than significant areas of engagement. Default:
\code{FALSE}.}
}
\value{
A list containing engagement maps for each network, the joint and
marginal PPMs for each network, and the parameters used for computing
engagement. If the input represented CIFTI- or NIFTI-format data, then the
engagements maps will be formatted accordingly.

Use \code{summary} to obtain information about the engagements results.
For CIFTI-format engagements, use \code{plot} to visualize the engagement
maps.
}
\description{
Identify areas of engagement in each network from the result of (spatial)
Bayesian brain mapping.
}
\examples{
\dontrun{
 engagements(bMap_result, alpha=.05, deviation=TRUE)
}
}
