% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgeS_Computation.R
\name{AgeS_Computation}
\alias{AgeS_Computation}
\title{Bayesian analysis for the OSL age estimation of various samples}
\usage{
AgeS_Computation(DATA, SampleNames, Nb_sample, PriorAge = rep(c(0.01, 100),
  Nb_sample), BinPerSample = rep(1, Nb_sample), SavePdf = FALSE,
  OutputFileName = c("MCMCplot", "summary"), OutputFilePath = c(""),
  SaveEstimates = FALSE, OutputTableName = c("DATA"),
  OutputTablePath = c(""), THETA = c(), sepTHETA = c(","),
  StratiConstraints = c(), sepSC = c(","), LIN_fit = TRUE,
  Origin_fit = FALSE, distribution = c("cauchy"), Iter = 50000, t = 5,
  Nb_chaines = 3)
}
\arguments{
\item{DATA}{list of objects: LT, sLT, ITimes, dLab, ddot_env, regDose, J, K, Nb_measurement,
provided by the function \code{\link{Generate_DataFile}} or \code{\link{Generate_DataFile_MG}} or \code{\link{Concat_DataFile}}.
\code{DATA} contains informations for more than one sample.
If there is stratigraphic relations between samples, informations in DATA must be ordered by order of incresing ages.
See the details section to for more informations.}

\item{SampleNames}{character vector: names of samples. The length of this vector is equal to \code{Nb_sample}.}

\item{Nb_sample}{integer : number of samples, \code{Nb_sample>1}.}

\item{PriorAge}{numeric vector (with default): lower and upper bounds for age parameter of each sample (in ka).
Note that, \code{length(PriorAge)=2*Nb_sample}
and \code{PriorAge[2i-1,2i]} correponds to the lower and upper bounds of sample whose number ID is equal to \code{i}.}

\item{BinPerSample}{integer vector (with default): vector with the number of BIN files per sample.
The length of this vector is equal to \code{Nb_sample}.
\code{BinPerSample}[i] correponds to the number of BIN files for the sample whose number ID is equal to \code{i}.
For more information to fill this vector, we refer to detatils in \code{\link{Generate_DataFile}} or in \code{\link{Generate_DataFile_MG}}.}

\item{SavePdf}{boolean (with default): if TRUE save graphs in pdf file named \code{OutputFileName} in folder \code{OutputFilePath}.}

\item{OutputFileName}{character (with default): name of the pdf file that will be generated by the function if \code{SavePdf}=TRUE;
\code{length(OutputFileName)=2}, see \bold{PLOT OUTPUT} in \bold{Value} section for more informations.}

\item{OutputFilePath}{character (with default): path to the pdf file that will be generated by the function if \code{SavePdf}=TRUE.
If it is not equal to "", it must be terminated by "/".}

\item{SaveEstimates}{boolean (with default): if TRUE save Bayes estimates, credible interval at level 68\% and 95\%  and
the result of the gelman en Rudin test of convergency, in a csv table named \code{OutputFileName} in folder \code{OutputFilePath}.}

\item{OutputTableName}{character (with default): name of the table that will be generated by the function if \code{SaveEstimates}=TRUE.}

\item{OutputTablePath}{character (with default): path to the table that will be generated by the function if \code{SaveEstimates}=TRUE.
If it is not equal to "", it must be terminated by "/".}

\item{THETA}{numeric matrix or character (with default): input object for systematic and individual error.
If systematic errors are considered, see the details section for instructions regarding how to correctly fill \code{THETA};
the user can refer to a matrix (numeric matrix) or to a csv file (character).
Otherwise, default value is suitable, and only individual errors are considered.}

\item{sepTHETA}{character (with default): if \code{THETA} is character,
indicate column separator in \code{THETA} csv file.}

\item{StratiConstraints}{numeric matrix or character(with default): input object for the statigraphic relation between samples.
If there is stratigraphic relation between samples see the details section for instructions regarding how to correctly fill
\code{StratiConstraints}; the user can refer to a matrix (numeric matrix) or to a csv file (character).
If there is no stratigraphic relation default value is suitable.}

\item{sepSC}{character (with default): if \code{StratiConstraints} is character,
indicate column separator in \code{StratiConstraints} .csv file.}

\item{LIN_fit}{logical (with default): if TRUE (default) allows a linear component,
on top of the (default) saturating exponential curve, for the fitting of dose response curves.
See details section for more informations on the proposed dose response curves.}

\item{Origin_fit}{logical (with default): if TRUE, forces the dose response curves to pass through the origin.
See details section for more informations on the proposed growth curves.}

\item{distribution}{character (with default): type of distribution that defines
how individual equivalent dose values are distributed around the palaeodose.
Allowed inputs are \bold{"cauchy"}, \bold{"gaussian"}, \bold{"lognormal_A"} and \bold{"lognormal_M"}, see details section for more informations.}

\item{Iter}{integer (with default): number of iterations for the MCMC computation (for more information see \code{\link{jags.model}}).}

\item{t}{integer (with default): 1 every \code{t} iterations of the MCMC is considered for sampling the posterior distribution
(for more information see \code{\link{jags.model}}).}

\item{Nb_chaines}{integer (with default): number of independent chains for the model (for more information see \code{\link{jags.model}}).}
}
\value{
\bold{NUMERICAL OUTPUT}

\enumerate{
\item \bold{A list containing the following objects:}
 \itemize{
  \item \bold{Sampling}: that corresponds to a sample of the posterior distributions
 of the age (in ka), palaeodose (in Gy) and equivalent dose dispersion (in Gy) parameters for each sample;
  \item \bold{Model_GrowthCurve}: stating which dose response fitting option was chosen;
  \item \bold{Distribution}: stating which distribution was chosen to model the dispersion of
 individual equivalent dose values around the palaeodose of the sample;
  \item \bold{PriorAge}: stating the priors used for the age parameter (in ka);
  \item \bold{StratiConstraints}: stating the stratigraphic relations between samples considered in the model;
  \item \bold{CovarianceMatrix}: stating the covariance matrix of error used in the model, highlighting common errors between samples or not.
 }
  \item\bold{The Gelman and Rudin test of convergency}: prints the result of the Gelman and Rudin test of convergency for
the age, palaeodose and equivalent dose dispersion parameters for each sample.
A result close to one is expected.\cr
In addition, the user must visually assess the convergency of the trajectories by looking at the graph
generated by the function (see \bold{PLOT OUTPUT} for more informations).\cr
If both convergencies (Gelman and Rudin test and plot checking) are satisfactory,
the user can consider the estimates as valid.
Otherwise, the user may try increasing the number of MCMC interations (\code{Iter})
or being more precise on the \code{PriorAge} parameter (for example specify if it is a young sample \code{c(0.01,10)} an old sample \code{c(10,100)}),
or changing the parameter \code{distribution} or the growth curve, to reach convergency.
  \item \bold{Credible intervals and Bayes estimates}: prints the Bayes esitmates, the credible intervals at 95\% and 68\% for
the age, palaeodose and equivalent dose dispersion parameters for each sample.
}

\bold{PLOT OUTPUT}

\enumerate{
 \item\bold{MCMC trajectories}: A graph with the MCMC trajectories and posterior distributions of the age, palaeodose and equivalent dose dispersion parameters
is displayed, there is one page per sample. \cr
The first line of the figure correponds to the age parameter, the second to the palaeodose parameter
and the third to the equivalent dose dispersion parameter.
On each line, the plot on the left represents the MCMC trajectories, and the one on the right the posterior distribution of the parameter.
 \item \bold{Summary of sample age estimates}: plot credible intervals and Bayes estimate of each sample age on a same graph.
}

To give the results in a publication, we recommend to give the Bayes estimate of the parameters as well as the credible interval at 95\% or 68\%.
}
\description{
This function computes the age (in ka) of at least two samples according to the model developed in Combes and Philippe (2017),
based on outputs of \code{\link{Generate_DataFile}} or \code{\link{Generate_DataFile_MG}}
or both of them using \code{\link{Concat_DataFile}}.\cr
Samples, for which data is avalilable in several BIN files, can be analysed.\cr
Single-grain or Multi-grain OSL measurements can be analysed simultaneouly.
}
\details{
\bold{** How to fill} \code{StratiConstraints} \bold{? **}\cr

If there is stratigraphic relations between samples, \bold{informations in DATA must be ordered by order of increasing ages}.
To do this the user can either fill right \code{Names} in \code{\link{Generate_DataFile}} or in \code{\link{Generate_DataFile_MG}}
(as it is indicated in Details section of these function), or ordered by order of increasing ages
outputs of \code{\link{Generate_DataFile}} or \code{\link{Generate_DataFile_MG}} in \code{\link{Concat_DataFile}}.

The user can fill the \code{StratiConstraints} matrix as follow.
\enumerate{
 \item \bold{Size of the matrix}: row number of \code{StratiConstraints} matrix is equal to \code{Nb_sample+1},
and column number is equal to \code{Nb_sample}.
 \item \bold{First line of the matrix}:
for all \code{i in {1,...,Nb_Sample}}, \code{StratiConstraints[1,i]=1} that means the lower bound of the sample age (given in \code{PriorAge[2i-1]})
for the sample whose number ID is equal to \code{i}, is taken into account.
 \item \bold{Sample relations}: for all  \code{j in {2,...,Nb_Sample+1}} and all \code{i in {j,...,Nb_Sample}},
\code{StratiConstraints[j,i]=1} if sample age whose number ID is equal to \code{j-1} is lower than sample age whose number ID is equal to \code{i}.
Otherwise, \code{StratiConstraints[j,i]=0}.
}
Note that \code{StratiConstraints_{2:Nb_sample+A,1:Nb_sample}} is a upper triangular matrix.

The user can also use \code{\link{SCMatrix}} or \code{\link{SC_Ordered}} (if all samples are ordered) functions
to construct the \code{StratiConstraints} matrix.

The user can also refer to a csv file that containts the relation between samples as defined above.
The user must take care about the separator used in the csv file using the argument \code{sepSC}.\cr

\bold{** How to fill} \code{THETA} \bold{covariance matrix concerning common and individual error? **}\cr

If systematic errors are considered, the user can fill the \code{THETA} matrix as follow.
\itemize{
 \item row number of \code{THETA} is equal the column number, equal to \code{Nb_sample}.
 \item For all \code{i in {1,...,Nb_sample}}, \code{THETA[i,i]} containts individual error
 plus systematic error of the sample whose number ID is equal to \code{i}.
 \item For all \code{i,j in {1,...,Nb_sample}} and \code{i} different from \code{j} ,
\code{THETA[i,j]} containts common error between samples whose number ID are equal to \code{i} and \code{j}.
}
Note that \code{THETA[i,j]} is a symetric matrix.

The user can also refer to a .csv file that containts the errors as defined above.\cr

\bold{** Option on growth curves **}\cr

As for \code{\link{Age_Computation}} and \code{\link{Palaeodose_Computation}}, the user can choose from 4 dose response curves:
\itemize{
  \item \bold{Saturating exponential plus linear growth} (\code{AgesMultiCS2_EXPLIN}):

  for all \code{x} in IR+, \code{f(x)=a(1-exp(-x/b))+cx+d}; select
  \itemize{
    \item \code{LIN_fit=TRUE}
    \item \code{Origin_fit=FALSE}
  }
  \item \bold{Saturating exponential growth} (\code{AgesMultiCS2_EXP}):

  for all \code{x} in IR+, \code{f(x)=a(1-exp(-x/b))+d}; select
  \itemize{
    \item \code{LIN_fit=FALSE}
    \item \code{Origin_fit=FALSE}
  }
  \item \bold{Saturating exponential plus linear growth and fitting through the origin} (\code{AgesMultiCS2_EXPLINZO}):

  for all \code{x} in IR+, \code{f(x)=a(1-exp(-x/b))+cx}; select
  \itemize{
    \item \code{LIN_fit=TRUE}
    \item \code{Origin_fit=TRUE}
  }
  \item \bold{Saturating exponential growth and fitting through the origin} (\code{AgesMultiCS2_EXPZO}):

  for all \code{x} in IR+, \code{f(x)=a(1-exp(-x/b))}; select
  \itemize{
    \item \code{LIN_fit=FALSE}
    \item \code{Origin_fit=TRUE}
  }
}

\bold{** Option on equivalent dose distribution around the palaeodose **}\cr

The use can choose between :
\itemize{
  \item \code{cauchy}: a Cauchy distribution with location parameter equal to the palaeodose of the sample;
  \item \code{gaussian}: a Gaussian distribution with mean equal to the palaeodose of the sample;
  \item \code{lognormal_A}: a log-normal distribution with mean or \bold{A}verage equal to the palaeodose of the sample:
  \item \code{lognormal_M}: a log-normal distribution with \bold{M}edian equal to the palaeodose of the sample.
}
}
\examples{
## Load data
data(DATA1,envir = environment())
data(DATA2,envir = environment())
Data=Concat_DataFile(DATA2,DATA1)

## Age computation of samples GDB5 and GDB3,
priorage=c(1,10,20,60) # these samples are not young
## without common error and without stratigraphic constraints
Age=AgeS_Computation(DATA=Data,Nb_sample=2,SampleNames=c("GDB5","GDB3"),
      PriorAge=priorage,Iter=50,Nb_chaines=2)

## Age computation of samples GDB5 and GDB3,
## without common error, assuming GDB5 age younder than GDB3 age
\dontrun{
(SC=matrix(data=c(1,1,0,1,0,0),ncol=Nb_sample,nrow = (Nb_sample+1),byrow = T))
Age=AgeS_Computation(DATA=Data,Nb_sample=2,SampleNames=c("GDB5","GDB3"),
  PriorAge=priorage,StratiConstraints=SC,Iter=10000)
}

}
\references{
Combes, Benoit and Philippe, Anne, 2017.
Bayesian analysis of multiplicative Gaussian error for multiple ages estimation in optically stimulated luminescence dating.
Quaternary Geochronology (39, 24-34)

Combes, B., Philippe, A., Lanos, P., Mercier, N., Tribolo, C., Guerin, G., Guibert, P., Lahaye, C., 2015.
A Bayesian central equivalent dose model for optically stimulated luminescence dating.
Quaternary Geochronology 28, 62-70. doi:10.1016/j.quageo.2015.04.001
}
\seealso{
\code{\link{Generate_DataFile}}, \code{\link{Generate_DataFile_MG}},
\code{\link{rjags}}, \code{\link{MCMC_plot}}, \code{\link{SCMatrix}}
\code{\link{Age_Computation}}, \code{\link{Palaeodose_Computation}}
}
\author{
Claire Christophe, Anne Philippe, Guillaume Guerin
}
