% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/loadResults.R
\name{loadResults}
\alias{loadResults}
\title{Loads result files for id vector.}
\usage{
loadResults(reg, ids, part = NA_character_, simplify = FALSE,
  use.names = "ids", missing.ok = FALSE)
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
Registry.}

\item{ids}{[\code{integer}]\cr
Ids of jobs.
Default is all done jobs.}

\item{part}{[\code{character}]
Only useful for multiple result files, then defines which result file part(s) should be loaded.
\code{NA} means all parts are loaded, which is the default.}

\item{simplify}{[\code{logical(1)}]\cr
Should the result be simplified to a vector, matrix or higher dimensional array if possible?
Default is \code{TRUE}.}

\item{use.names}{[\code{character(1)}]\cr
Name the results with job ids (\dQuote{ids}), stored job names (\dQuote{names})
or return a unnamed result (\dQuote{none}).
Default is \code{ids}.}

\item{missing.ok}{[\code{logical(1)}]\cr
If \code{FALSE} an error is thrown if the results are not found.
Otherwise missing results are imputed to \code{NULL}.
Default is \code{FALSE}.}
}
\value{
[\code{list}]. Results of jobs as list, possibly named by ids.
}
\description{
Loads result files for id vector.
}
\seealso{
\code{\link{reduceResults}}
}

