% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/elements.R
\name{elements}
\alias{elements}
\alias{elements<-}
\alias{elements,TidySet-method}
\alias{elements<-,TidySet-method}
\alias{replace_elements}
\alias{nElements,TidySet-method}
\title{Elements of the TidySet}
\usage{
elements(object)

elements(object) <- value

\S4method{elements}{TidySet}(object)

\S4method{elements}{TidySet}(object) <- value

replace_elements(object, value)

\S4method{nElements}{TidySet}(object)
}
\arguments{
\item{object}{A TidySet object.}

\item{value}{Modification of the elements.}
}
\value{
A \code{data.frame} with information about the elements
}
\description{
Given TidySet retrieve the elements or substitute them.
}
\section{Methods (by class)}{
\itemize{
\item \code{elements(TidySet)}: Retrieve the elements

\item \code{elements(TidySet) <- value}: Modify the elements

\item \code{nElements(TidySet)}: Return the number of elements

}}
\examples{
TS <- tidySet(list(A = letters[1:5], B = letters[2:10]))
elements(TS)
elements(TS) <- data.frame(elements = letters[10:1])
TS2 <- replace_elements(TS, data.frame(elements = letters[1:11]))
nElements(TS)
nElements(TS2)
}
\seealso{
\code{\link[=nElements]{nElements()}}

Other slots: 
\code{\link{relations}()},
\code{\link{sets}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
\concept{slots}
