% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{simEnv}
\alias{simEnv}
\alias{simEnv,Arena-method}
\title{Main function for simulating all processes in the environment}
\usage{
simEnv(object, time, lrw = NULL, continue = F)

\S4method{simEnv}{Arena}(object, time, lrw = NULL, continue = F)
}
\arguments{
\item{object}{An object of class Arena or Eval.}

\item{time}{A number giving the number of iterations to perform for the simulation}

\item{lrw}{A numeric value needed by solver to estimate array size (by default lwr is estimated in the simEnv() by the function estimate_lrw())}

\item{continue}{A boolean indicating whether the simulation should be continued or restarted.}
}
\value{
Returns an object of class \code{Eval} which can be used for subsequent analysis steps.
}
\description{
The generic function \code{simEnv} for a simple simulation of the environment.
}
\details{
The returned object itself can be used for a subsequent simulation, due to the inheritance between \code{Eval} and \code{Arena}.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
addOrg(arena,bac,amount=10) #add 10 organisms
addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,10)
}
\seealso{
\code{\link{Arena-class}} and \code{\link{Eval-class}}
}

