% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate.R
\docType{methods}
\name{simulate,Regression-method}
\alias{simulate,Regression-method}
\title{Simulation of regression model}
\usage{
\S4method{simulate}{Regression}(object, nsim = 1, seed = NULL, t,
  plot.series = TRUE)
}
\arguments{
\item{object}{class object of parameters: "Diffusion"}

\item{nsim}{number of trajectories to simulate. Default is 1.}

\item{seed}{optional: seed number for random number generator}

\item{t}{vector of time points}

\item{plot.series}{logical(1), if TRUE, simulated series are depicted grafically}
}
\description{
Simulation of the regression model
  \eqn{y_i = f(\phi, t_i) + \epsilon_i, \epsilon_i\sim N(0,\gamma^2\widetilde{s}(t_i))}.
}
\examples{
model <- set.to.class("Regression", parameter = list(phi = 5, gamma2 = 0.1),
   fun = function(phi, t) phi*t)
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, plot.series = TRUE)
}

