% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/estimate.R
\docType{methods}
\name{estimate,hiddenDiffusion-method}
\alias{estimate,hiddenDiffusion-method}
\title{Estimation for hidden diffusion process}
\usage{
\S4method{estimate}{hiddenDiffusion}(model.class, t, data, nMCMC, propSd,
  adapt = TRUE, proposal = c("normal", "lognormal"), Npart = 100)
}
\arguments{
\item{model.class}{class of the hidden diffusion model including all required information, see \code{\link{hiddenDiffusion-class}}}

\item{t}{vector of time points}

\item{data}{vector of observation variables}

\item{nMCMC}{length of Markov chain}

\item{propSd}{vector of proposal variances for \eqn{\phi}}

\item{adapt}{if TRUE (default), proposal variance is adapted}

\item{proposal}{proposal density: "normal" (default) or "lognormal" (for positive parameters)}

\item{Npart}{number of particles in the particle Gibbs sampler}
}
\description{
Bayesian estimation of the model
  \eqn{Z_i = Y_{t_i} + \epsilon_i, dY_t = b(\phi,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t,
  \epsilon_i\sim N(0,\sigma^2), Y_{t_0}=y_0(\phi, t_0)} with a particle Gibbs sampler.
}
\examples{
model <- set.to.class("hiddenDiffusion", y0.fun = function(phi, t) 0.5,
             parameter = list(phi = 5, gamma2 = 1, sigma2 = 0.1))
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, plot.series = TRUE)
est <- estimate(model, t, data$Z, 100)  # nMCMC should be much larger!
plot(est)

\dontrun{
# OU
b.fun <- function(phi, t, y) phi[1]-phi[2]*y
model <- set.to.class("hiddenDiffusion", y0.fun = function(phi, t) 0.5,
               parameter = list(phi = c(10, 1), gamma2 = 1, sigma2 = 0.1),
               b.fun = b.fun, sT.fun = function(t, x) 1)
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, plot.series = TRUE)
est <- estimate(model, t, data$Z, 1000)
plot(est)
}
}
\references{
Andrieu, C., A. Doucet and R. Holenstein (2010). Particle Markov Chain Monte Carlo Methods.
Journal of the Royal Statistical Society B 72, pp. 269-342.
}

