% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/helpingFunctions.R
\name{InvMethod}
\alias{InvMethod}
\title{Inversion Method}
\usage{
InvMethod(Fun, len, candArea, grid = 1e-05, method = c("vector", "free"))
}
\arguments{
\item{Fun}{cumulative distribution function}

\item{len}{number of samples}

\item{candArea}{candidate area}

\item{grid}{fineness degree}

\item{method}{vectorial ("vector") or not ("free")}
}
\description{
Algorithm to sample from cumulative distribution function, if no inverse function is analytically available.
}
\examples{
test <- InvMethod(function(x) pnorm(x, 5, 1), 1000, candArea = c(0, 10), method = "free")
plot(density(test))
curve(dnorm(x, 5, 1), col = 2, add = TRUE)
}
\references{
Devroye, L. (1986). Non-Uniform Random Variate Generation. New York: Springer.
}

