% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bgnbd.ConditionalExpectedTransactions}
\alias{bgnbd.ConditionalExpectedTransactions}
\title{BG/NBD Conditional Expected Transactions}
\usage{
bgnbd.ConditionalExpectedTransactions(params, T.star, x, t.x, T.cal)
}
\arguments{
\item{params}{BG/NBD parameters - a vector with r, alpha, a, and b, in that order. r and alpha are unobserved parameters for the NBD transaction process. a and b are unobserved parameters for the Beta geometric dropout process.}

\item{T.star}{length of time for which we are calculating the expected
number of transactions.}

\item{x}{number of repeat transactions in the calibration period
T.cal, or a vector of calibration period frequencies.}

\item{t.x}{time of most recent repeat transaction, or a vector of
recencies.}

\item{T.cal}{length of calibration period, or a vector of
calibration period lengths.}
}
\value{
Number of transactions a customer is expected to make in a
time period of length t, conditional on their past behavior. If
any of the input parameters has a length greater than 1, this will
be a vector of expected number of transactions.
}
\description{
Uses BG/NBD model parameters and a customer's past transaction
behavior to return the number of transactions they are expected to
make in a given time period.
}
\details{
E[X(T.cal, T.cal + T.star) | x, t.x, r, alpha, a, b]

\code{T.star}, \code{x}, \code{t.x}, and \code{T.cal} may be
vectors. The standard rules for vector operations apply - if they
are not of the same length, shorter vectors will be recycled
(start over at the first element) until they are as long as the
longest vector. It is advisable to keep vectors to the same length
and to use single values for parameters that are to be the same
for all calculations. If one of these parameters has a length
greater than one, the output will be a vector of probabilities.
}
\examples{
params <- c(0.243, 4.414, 0.793, 2.426)
# Number of transactions a customer is expected to make in 2 time
# intervals, given that they made 10 repeat transactions in a time period
# of 39 intervals, with the 10th repeat transaction occurring in the 35th
# interval.
bgnbd.ConditionalExpectedTransactions(params, T.star=2, x=10, t.x=35, T.cal=39)

# We can also compare expected transactions across different
# calibration period behaviors:
bgnbd.ConditionalExpectedTransactions(params, T.star=2, x=5:20, t.x=25, T.cal=39)
}
\references{
Fader, Peter S.; Hardie, Bruce G.S.and Lee, Ka Lok. \dQuote{Computing P(alive) Using the BG/NBD Model.} December. 2008. Web. \url{http://www.brucehardie.com/notes/021/palive_for_BGNBD.pdf}
}
\seealso{
\code{\link{bgnbd.Expectation}}
}

