% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Music}
\alias{Music}
\title{Improvement scores for identical twins taught music recognition by two
techniques}
\format{A data frame/tibble with 12 observations on three variables
\describe{ 
\item{method1}{a numeric vector measuring the improvement scores on a music recognition test} 
\item{method2}{a numeric vector measuring the improvement scores on a music recognition test} 
\item{differ}{\code{method1} - \code{method2}} 
}}
\usage{
Music
}
\description{
Data for Exercise 7.59
}
\examples{

qqnorm(Music$differ)
qqline(Music$differ)
shapiro.test(Music$differ)
t.test(Music$method1, Music$method2, paired = TRUE)
# Or
t.test(Music$differ)
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Music, aes(x = differ)) + 
           geom_dotplot() + 
           theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
