% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Bigten}
\alias{Bigten}
\title{Graduation rates for student athletes and nonathletes in the Big Ten Conf.}
\format{A data frame/tibble  with 44 observations on the following four variables
\describe{ 
\item{school}{a factor with levels \code{Illinois},
\code{Indiana}, \code{Iowa}, \code{Michigan}, \code{Michigan State},
\code{Minnesota}, \code{Northwestern}, \code{Ohio State}, \code{Penn State},
\code{Purdue}, and \code{Wisconsin}} 
\item{rate}{graduation rate} 
\item{year}{factor with two levels \code{1984-1985} and \code{1993-1994}}
\item{status}{factor with two levels \code{athlete} and \code{student}}
}}
\source{
NCAA Graduation Rates Report, 2000.
}
\usage{
Bigten
}
\description{
Data for Exercises 1.124 and 2.94
}
\examples{

boxplot(rate ~ status, data = subset(Bigten, year = "1993-1994"), 
horizontal = TRUE, main = "Graduation Rates 1993-1994")
with(data = Bigten,
     tapply(rate, list(year, status), mean)
)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
