# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @export MAR
#' @name MAR
#' @title C++ function to estimate Pitman-Yor univariate mixtures via marginal sampler
#'
#'
#' @param data a vector of observations
#' @param grid vector to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param a0 parameter of scale component
#' @param b0 parameter of scale component
#' @param mass mass of Dirichlet process
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param process if 0 DP, if 1 PY
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#'
#' @examples{
#'   data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
#'   grid <- seq(-7, 7, length.out = 50)
#'   est_model <- MAR(data_toy, grid, 50, 10, 0, 1, 2, 1, 1, 100, 0, 1, 0, 1)
#'   \dontshow{
#'     data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
#'     grid <- seq(-7, 7, length.out = 50)
#'     est_model <- MAR(data_toy, grid, 50, 10, 0, 1, 2, 1, 1, 100, 0, 1, 0, 1)
#'   }
#'   \donttest{
#'     data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
#'     grid <- seq(-7, 7, length.out = 50)
#'     est_model <- MAR(data_toy, grid, 1000, 100, 0, 1, 2, 1, 1, 100, 0, 1, 0, 1)
#'   }
#' }
#'
NULL

#' @export MAR_mv
#' @name MAR_mv
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via marginal sampler
#'
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param S0 parameter of scale component
#' @param n0 parameter of scale component
#' @param mass mass of Dirichlet process
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#'
#' @examples{
#'   data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
#'                   c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
#'   grid <- as.matrix(expand.grid(seq(-7, 7, length.out = 50),
#'                     seq(-7, 7, length.out = 50)))
#'   est_model <- MAR_mv(data_toy, grid, 20, 10, c(0,0), 1, diag(1,2), 4, 1, 100, 0, 1, 0, 1, 1)
#'   \dontshow{
#'     data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
#'                   c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
#'     grid <- as.matrix(expand.grid(seq(-7, 7, length.out = 50),
#'                     seq(-7, 7, length.out = 50)))
#'     est_model <- MAR_mv(data_toy, grid, 20, 10, c(0,0), 1, diag(1,2), 4, 1, 100, 0, 1, 0, 1, 1)
#'   }
#'   \donttest{
#'     data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
#'                   c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
#'     grid <- as.matrix(expand.grid(seq(-7, 7, length.out = 50),
#'                     seq(-7, 7, length.out = 50)))
#'     est_model <- MAR_mv(data_toy, grid, 1000, 100, c(0,0), 1, diag(1,2), 4, 1, 100, 0, 1, 0, 1, 1)
#'   }
#' }
#'
NULL

MAR <- function(data, grid, niter, nburn, m0, k0, a0, b0, mass, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L) {
    .Call('_BNPmix_MAR', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, a0, b0, mass, nupd, out_param, out_dens, sigma_PY, print_message)
}

MAR_mv <- function(data, grid, niter, nburn, m0, k0, S0, n0, mass, nupd = 0L, out_param = 0L, out_dens = 1L, process = 0L, sigma_PY = 0, print_message = 1L, light_dens = 1L) {
    .Call('_BNPmix_MAR_mv', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, S0, n0, mass, nupd, out_param, out_dens, process, sigma_PY, print_message, light_dens)
}

#' @export cDDP
#' @name cDDP
#' @title C++ function to estimate DDP models with 1 grouping variables
#'
#'
#' @param data a vector of observations.
#' @param group group allocation of the data.
#' @param ngr number of groups.
#' @param grid vector to evaluate the density.
#' @param niter number of iterations.
#' @param nburn number of burn-in iterations.
#' @param m0 expectation of location component.
#' @param k0 tuning parameter of variance of location component.
#' @param a0 parameter of scale component.
#' @param b0 parameter of scale component.
#' @param mass mass of Dirichlet process.
#' @param wei prior weight of the specific processes.
#' @param napprox number of approximating values.
#' @param n_approx_unif number of approximating values of the importance step for the weights updating.
#' @param nupd number of iterations to show current updating.
#' @param out_dens if TRUE, return also the estimated density (default TRUE).
#' @param print_message print the status.
#' @param light_dens if TRUE return only the posterior mean of the density
#'
#' @examples{
#'   data_toy <- c(rnorm(50, -4, 1), rnorm(100, 0, 1), rnorm(50, 4, 1))
#'   group_toy <- c(rep(1,100), rep(2,100))
#'   grid <- seq(-7, 7, length.out = 50)
#'   est_model <- cDDP(data_toy, group_toy, 2, grid, 20, 10,
#'     0, 1, 2, 1, 1, 0.5, 10, 1000, 100, 1, 1, 1)
#'   \dontshow{
#'     data_toy <- c(rnorm(50, -4, 1), rnorm(100, 0, 1), rnorm(50, 4, 1))
#'     group_toy <- c(rep(1,100), rep(2,100))
#'     grid <- seq(-7, 7, length.out = 50)
#'     est_model <- cDDP(data_toy, group_toy, 2, grid, 20, 10,
#'       0, 1, 2, 1, 1, 0.5, 10, 1000, 100, 1, 1, 1)
#'   }
#'   \donttest{
#'     data_toy <- c(rnorm(50, -4, 1), rnorm(100, 0, 1), rnorm(50, 4, 1))
#'     group_toy <- c(rep(1,100), rep(2,100))
#'     grid <- seq(-7, 7, length.out = 50)
#'     est_model <- cDDP(data_toy, group_toy, 2, grid, 1000, 100,
#'       0, 1, 2, 1, 1, 0.5, 10, 1000, 100, 1, 1, 1)
#'   }
#' }
#'
NULL

cDDP <- function(data, group, ngr, grid, niter, nburn, m0, k0, a0, b0, mass, wei, napprox, n_approx_unif, nupd = 0L, out_dens = 1L, print_message = 1L, light_dens = 1L) {
    .Call('_BNPmix_cDDP', PACKAGE = 'BNPmix', data, group, ngr, grid, niter, nburn, m0, k0, a0, b0, mass, wei, napprox, n_approx_unif, nupd, out_dens, print_message, light_dens)
}

#' @export cICS
#' @name cICS
#' @title C++ function to estimate Pitman-Yor univariate mixtures via importance conditional sampler
#'
#'
#' @param data a vector of observations
#' @param grid vector to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param a0 parameter of scale component
#' @param b0 parameter of scale component
#' @param mass mass of Dirichlet process
#' @param napprox number of approximating values
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#'
#' @examples{
#'   data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
#'   grid <- seq(-7, 7, length.out = 50)
#'   est_model <- cICS(data_toy, grid, 20, 10, 0, 1, 2, 1, 1, 10, 100, 0, 1, 0, 1)
#'   \dontshow{
#'     data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
#'     grid <- seq(-7, 7, length.out = 50)
#'     est_model <- cICS(data_toy, grid, 20, 10, 0, 1, 2, 1, 1, 10, 100, 0, 1, 0, 1)
#'   }
#'   \donttest{
#'     data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
#'     grid <- seq(-7, 7, length.out = 50)
#'     est_model <- cICS(data_toy, grid, 1000, 100, 0, 1, 2, 1, 1, 10, 100, 0, 1, 0, 1)
#'   }
#' }
#'
NULL

#' @export cICS_mv
#' @name cICS_mv
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via importance conditional sampler
#'
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param S0 parameter of scale component
#' @param n0 parameter of scale component
#' @param mass mass of Dirichlet process
#' @param napprox number of approximating values
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#'
#' @examples{
#'   data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
#'                   c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
#'   grid <- as.matrix(expand.grid(seq(-7, 7, length.out = 50),
#'                     seq(-7, 7, length.out = 50)))
#'   est_model <- cICS_mv(data_toy, grid, 20, 10,
#'     c(0,0), 1, diag(1,2), 4, 1, 100, 100, 0, 1, 0, 1, 1)
#'   \dontshow{
#'     data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
#'                   c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
#'     grid <- as.matrix(expand.grid(seq(-7, 7, length.out = 50),
#'                     seq(-7, 7, length.out = 50)))
#'     est_model <- cICS_mv(data_toy, grid, 20, 10,
#'       c(0,0), 1, diag(1,2), 4, 1, 100, 100, 0, 1, 0, 1, 1)
#'   }
#'   \donttest{
#'     data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
#'                   c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
#'     grid <- as.matrix(expand.grid(seq(-7, 7, length.out = 50),
#'                     seq(-7, 7, length.out = 50)))
#'     est_model <- cICS_mv(data_toy, grid, 1000, 100,
#'       c(0,0), 1, diag(1,2), 4, 1, 100, 100, 0, 1, 0, 1, 1)
#'   }
#' }
#'
NULL

cICS <- function(data, grid, niter, nburn, m0, k0, a0, b0, mass, napprox, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L) {
    .Call('_BNPmix_cICS', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, a0, b0, mass, napprox, nupd, out_param, out_dens, sigma_PY, print_message)
}

cICS_mv <- function(data, grid, niter, nburn, m0, k0, S0, n0, mass, napprox, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L, light_dens = 1L) {
    .Call('_BNPmix_cICS_mv', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, S0, n0, mass, napprox, nupd, out_param, out_dens, sigma_PY, print_message, light_dens)
}

#' @export cSLI
#' @name cSLI
#' @title C++ function to estimate Pitman-Yor univariate mixtures via slice sampler
#'
#'
#' @param data a vector of observations
#' @param grid vector to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param a0 parameter of scale component
#' @param b0 parameter of scale component
#' @param mass mass of Dirichlet process
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#'
#' @examples{
#'   data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
#'   grid <- seq(-7, 7, length.out = 50)
#'   est_model <- cSLI(data_toy, grid, 20, 10, 0, 1, 2, 1, 1, 100, 0, 1, 0, 1)
#'   \dontshow{
#'     data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
#'     grid <- seq(-7, 7, length.out = 50)
#'     est_model <- cSLI(data_toy, grid, 20, 10, 0, 1, 2, 1, 1, 100, 0, 1, 0, 1)
#'   }
#'   \donttest{
#'     data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
#'     grid <- seq(-7, 7, length.out = 50)
#'     est_model <- cSLI(data_toy, grid, 1000, 100, 0, 1, 2, 1, 1, 100, 0, 1, 0, 1)
#'   }
#' }
#'
NULL

#' @export cSLI_mv
#' @name cSLI_mv
#' @title C++ function to estimate Pitman-Yor multivariate mixtures via slice sampler
#'
#'
#' @param data a matrix of observations
#' @param grid matrix of points to evaluate the density
#' @param niter number of iterations
#' @param nburn number of burn-in iterations
#' @param m0 expectation of location component
#' @param k0 tuning parameter of variance of location component
#' @param S0 parameter of scale component
#' @param n0 parameter of scale component
#' @param mass mass of Dirichlet process
#' @param nupd number of iterations to show current updating
#' @param out_param if TRUE, return also the location and scale paramteres lists
#' @param out_dens if TRUE, return also the estimated density (default TRUE)
#' @param sigma_PY second parameter of PY
#' @param print_message print the status
#' @param light_dens if TRUE return only the posterior mean of the density
#'
#' @examples{
#'   data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
#'                   c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
#'   grid <- as.matrix(expand.grid(seq(-7, 7, length.out = 50),
#'                     seq(-7, 7, length.out = 50)))
#'   est_model <- cSLI_mv(data_toy, grid, 20, 10, c(0,0), 1, diag(1,2), 4, 1, 100, 0, 1, 0, 1, 1)
#'   \dontshow{
#'     data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
#'                   c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
#'     grid <- as.matrix(expand.grid(seq(-7, 7, length.out = 50),
#'                     seq(-7, 7, length.out = 50)))
#'     est_model <- cSLI_mv(data_toy, grid, 20, 10, c(0,0), 1, diag(1,2), 4, 1, 100, 0, 1, 0, 1, 1)
#'   }
#'   \donttest{
#'     data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
#'                   c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
#'     grid <- as.matrix(expand.grid(seq(-7, 7, length.out = 50),
#'                     seq(-7, 7, length.out = 50)))
#'     est_model <- cSLI_mv(data_toy, grid, 1000, 100, c(0,0), 1, diag(1,2), 4, 1, 100, 0, 1, 0, 1, 1)
#'   }
#' }
#'
NULL

cSLI <- function(data, grid, niter, nburn, m0, k0, a0, b0, mass, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L) {
    .Call('_BNPmix_cSLI', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, a0, b0, mass, nupd, out_param, out_dens, sigma_PY, print_message)
}

cSLI_mv <- function(data, grid, niter, nburn, m0, k0, S0, n0, mass, nupd = 0L, out_param = 0L, out_dens = 1L, sigma_PY = 0, print_message = 1L, light_dens = 1L) {
    .Call('_BNPmix_cSLI_mv', PACKAGE = 'BNPmix', data, grid, niter, nburn, m0, k0, S0, n0, mass, nupd, out_param, out_dens, sigma_PY, print_message, light_dens)
}

