% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_predict.R
\name{prepDatForPredict}
\alias{prepDatForPredict}
\title{Exclude rows with missing data on predictor variables}
\usage{
prepDatForPredict(formula, newdata)
}
\arguments{
\item{formula}{Model formula}

\item{newdata}{data.frame containing all variables that appear in the model}
}
\value{
Object of class \code{\link[stats]{na.exclude}}
}
\description{
Rows with missing values on predictor variables are excluded.
An unused column for the dependent variable is added to avoid errors.
}
\details{
A column of ones for the dependent variable is added. Otherwise
\code{\link[stats]{model.matrix}} tries to take it from the formula's
environment, which is the original data. This usually results in an error due
to unequal variable length. This column is however not used.
}
