% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleResids.R
\name{wildbootAddResids}
\alias{wildbootAddResids}
\title{Sample residuals according to a new model}
\usage{
wildbootAddResids(
  means,
  sampling_errors,
  method,
  rescaleResids,
  model,
  invTransFun,
  wild_bootstrap,
  wild_bootType,
  ...
)
}
\arguments{
\item{means}{a vector of means}

\item{sampling_errors}{Sampling vector to resample errors from. Used only if
\code{error} is 4 and is passed as argument to \code{\link{generateData}}.
If \code{sampling_errors = NULL} (default), mean residuals at off-axis
points between observed and predicted response are taken.}

\item{method}{What assumption should be used for the variance of on- and 
off-axis points. This argument can take one of the values from 
\code{c("equal", "model", "unequal")}. With the value \code{"equal"} as the
default. \code{"equal"} assumes that both on- and off-axis points have the 
same variance, \code{"unequal"} estimates a different parameter for on- and 
off-axis points and \code{"model"} predicts variance based on the average 
effect of an off-axis point. If no transformations are used the 
\code{"model"} method is recommended. If transformations are used, only the
\code{"equal"} method can be chosen.}

\item{rescaleResids}{a boolean indicating whether to rescale residuals,
or else normality of the residuals is assumed.}

\item{model}{The mean-variance model}

\item{invTransFun}{the inverse transformation function, back to the variance domain}

\item{wild_bootstrap}{Whether special bootstrap to correct for
heteroskedasticity should be used. If \code{wild_bootstrap = TRUE}, errors
are generated from \code{sampling_errors} multiplied by a random variable
following Rademacher distribution. Argument is used only if \code{error = 4}.}

\item{wild_bootType}{Type of distribution to be used for wild bootstrap. If \code{wild_bootstrap = TRUE}, 
errors are generated from "rademacher", "gamma", "normal" or "two-point" distribution.}

\item{...}{passed on to predictVar}
}
\value{
sampled residuals
}
\description{
Sample residuals according to a new model
}
