% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_occurrence_state}
\alias{BIEN_occurrence_state}
\title{Extract species occurrence records by state.}
\usage{
BIEN_occurrence_state(country, state, cultivated = FALSE,
  only.new.world = TRUE, print.query = FALSE, all.taxonomy = FALSE,
  native.status = FALSE, observation.type = FALSE,
  political.boundaries = FALSE, ...)
}
\arguments{
\item{country}{A single country or vector of countries.}

\item{state}{A single state or a vector of states.}

\item{cultivated}{Return cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{all.taxonomy}{Return all taxonomic information?  This includes the raw data as well as the "scrubbed" data.}

\item{native.status}{Return information on introduction status?  The default value is FALSE. A value of TRUE also returns additional information on introduction status.}

\item{observation.type}{Return information on type of observation (i.e. specimen vs. plot)?  The default value is FALSE.}

\item{political.boundaries}{Return information on political boundaries for an observation? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
Dataframe containing occurrence records for the specified states/provinces.
}
\description{
BIEN_occurrence_state extracts occurrences records for the specified state(s).
}
\note{
This function requires you supply either 1) a single country with one or more states, or 2) vectors of equal length for each political level.
}
\examples{
\dontrun{
BIEN_occurrence_state("United States","Rhode Island")
state_vector<-c("Rhode Island","Maryland")
BIEN_occurrence_state(country="United States",state=state_vector)}
}
\seealso{
Other occurrence functions: \code{\link{BIEN_occurrence_box}},
  \code{\link{BIEN_occurrence_country}},
  \code{\link{BIEN_occurrence_county}},
  \code{\link{BIEN_occurrence_family}},
  \code{\link{BIEN_occurrence_genus}},
  \code{\link{BIEN_occurrence_records_per_species}},
  \code{\link{BIEN_occurrence_shapefile}},
  \code{\link{BIEN_occurrence_species}}
}

