% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare_ppc.default.R
\name{plot.ggm_compare_ppc}
\alias{plot.ggm_compare_ppc}
\title{Plot \code{ggm_compare_ppc} Objects}
\usage{
\method{plot}{ggm_compare_ppc}(
  x,
  critical = 0.05,
  col_noncritical = "#84e184A0",
  col_critical = "red",
  point_size = 2,
  ...
)
}
\arguments{
\item{x}{An object of class \code{ggm_compare_ppc}}

\item{critical}{Numeric. The 'significance' level
(defaults to \code{0.05}).}

\item{col_noncritical}{Character string. Fill color for the non-critical region
(defaults to \code{"#84e184A0"}).}

\item{col_critical}{Character string. Fill color for the critical region
(defaults to \code{"red"}).}

\item{point_size}{Numeric. The point size for the observed score
(defaults to \code{2}).}

\item{...}{Currently ignored.}
}
\value{
An object (or list of objects) of class \code{ggplot}.
}
\description{
Plot the predictive check with \code{\link[ggridges]{ggridges}}
}
\note{
See
\href{https://CRAN.R-project.org/package=ggridges/vignettes/introduction.html}{ggridges} for
many examples.
}
\examples{
\donttest{
# data
Y <- bfi

#############################
######### global ############
#############################
# males
Ym <- subset(Y, gender == 1,
             select = - c(gender, education))

# females

Yf <- subset(Y, gender == 2,
             select = - c(gender, education))


global_test <- ggm_compare_ppc(Ym, Yf,
                               iter = 250,
                               progress = FALSE)

plot(global_test)
}
}
\seealso{
\code{\link{ggm_compare_ppc}}
}
