% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{ptsd_cor4}
\alias{ptsd_cor4}
\title{post-traumatic stress disorder correlation matrix (# 4)}
\format{A (correlation) matrix with 16 variables}
\description{
A dataset containing items that measure Post-traumatic stress disorder symptoms. There are 16 variables in total.
The correlation matrix was estimated from 965 individuals.
}
\details{
\itemize{
  \item Intrusive Thoughts
  \item Nightmares
  \item Flashbacks
  \item Physiological/psychological reactivity
  \item Avoidance of thoughts
  \item Avoidance of situations
  \item Amnesia
  \item Disinterest in activities
  \item Feeling detached
  \item Emotional numbing
  \item Foreshortened future
  \item Sleep problems
  \item Irritability
  \item Concentration problems
  \item Hypervigilance
  \item Startle response
}
}
\examples{
data(ptsd_cor4)
Y <- MASS::mvrnorm(n = 965, mu = rep(0, 16),
                   Sigma = ptsd_cor4,  empirical = TRUE)
}
\references{
Fried, E. I., Eidhof, M. B., Palic, S., Costantini, G., Huisman-van Dijk, H. M., Bockting, C. L., ... & Karstoft, K. I. (2018).
Replicability and generalizability of posttraumatic stress disorder (PTSD) networks: a cross-cultural multisite study of PTSD
symptoms in four trauma patient samples. Clinical Psychological Science, 6(3), 335-351.
}
\keyword{datasets}
