% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/utils.R
\name{eqr}
\alias{eqr}
\title{Ecological Quality Ratio (EQR)}
\usage{
eqr(x, bad, good)
}
\arguments{
\item{x}{numeric vector containing benthic indices}

\item{bad}{the reference value for a bad status}

\item{good}{the reference value for a good status}
}
\value{
numeric vector with EQR-values: low values indicate bad ecological
     quality and high values indicate good ecological quality.
}
\description{
The ecological quality ratio is the ratio beween a parameter value and its
 reference value:
 \deqn{EQR = \frac{x-bad}{good-bad}}{EQR = (x-bad)/(good-bad)}
 Depending on \code{bad} and \code{good}, the EQR usually
 (but not necessarily!) varies between 0 (bad ecological quality) and 1 (good
 ecological quality).
}

