% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{BCHMplot_cluster}
\alias{BCHMplot_cluster}
\title{Plot the clustering results of subgroups.}
\usage{
BCHMplot_cluster(res, col, pch, cex = 2)
}
\arguments{
\item{res}{BCHM calculation results.}

\item{col}{Color vector}

\item{pch}{pch vector}

\item{cex}{size of points}
}
\value{
None
}
\description{
plot the observed response rate versus subgroup ID with clusters coded by the color of dots.
}
\examples{
nDat = c(25, 25, 25, 25) # total number of patients
xDat = c(2, 3, 8, 6)  # number of responses
alpha <- 1e-20 
d0 <- 0.0 
alpha1 = 50   
beta1 = 10  
tau2 <- 0.1  
phi1 <- 0.1  
deltaT <- 0.2  
thetaT <- 0.60   

res <- BCHM(nDat = nDat,
            xDat = xDat,
            alpha = alpha,
            d0 = d0,             
            alpha1 = alpha1, 
            beta1 = beta1,
            tau2 = tau2,
            phi1 = phi1, 
            deltaT = deltaT,
            thetaT = thetaT,
            burnIn = 100,
            MCIter = 200,
            MCNum = 1000,
            seed = 1000
)
print(res$SMatrix)
print(res$Result)
col <- res$Result[,4]

BCHMplot_cluster(res, col, pch=16)

}
\seealso{
\code{\link{BCHM} Perform the analysis based on the BCHM design.}

\code{\link{BCHMplot_post_value} Plot the posterior response of subgroups. }

\code{\link{BCHMplot_post_dist} Plot the posterior distributions of subgroups. }
}
