% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateInputs.R
\name{CreateInputs}
\alias{CreateInputs}
\title{CreateInputs}
\usage{
CreateInputs(x, print.lincom = TRUE)
}
\arguments{
\item{x}{A \code{rjags}, \code{bugs} or \code{stanfit} object, containing
the results of a call to either \code{jags}, (under \code{R2jags}), bugs
(under \code{R2WinBUGS} or \code{R2OpenBUGS}), or \code{stan} (under
\code{rstan}).}

\item{print.lincom}{A TRUE/FALSE indicator. If set to \code{TRUE} (default)
then prints the output of the procedure trying to assess whether there are
some parameters that are a linear combination of others (in which case
they are removed).}
}
\value{
\item{mat}{A data.frame contaning all the simulations for all the
monitored parameters} \item{parameters}{A character vectors listing the
names of all the monitored parameters}
}
\description{
Creates an object containing the matrix with the parameters simulated using
the MCMC procedure (using JAGS, BUGS or Stan) and a vector of parameters
(strings) that can be used to perform the expected value of partial
information analysis. In the process, \code{CreateInputs} also checks for
linear dependency among columns of the PSA samples or columns having
constant values and removes them to only leave the fundamental parameters
(to run VoI analysis). This also deals with simulations stored in a
\code{.csv} or \code{.txt} file (eg as obtained using bootstrapping from a
non-Bayesian model)
}
\seealso{
\code{\link{bcea}}, \code{\link{evppi}}
}
\author{
Gianluca Baio and Mark Strong
}
\keyword{R2OpenBUGS}
\keyword{R2WinBUGS}
\keyword{R2jags}
