% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{cwm}
\alias{cwm}
\title{Community Weighted Mean.}
\usage{
cwm(comm, trait, abund = TRUE, na.rm = FALSE)
}
\arguments{
\item{comm}{A sites x species matrix, with incidence or abundance data about the species in the community.}

\item{trait}{A species x traits matrix, with trait values for each species in comm.}

\item{abund}{A boolean (T/F) indicating whether abundance data should be used (TRUE) or converted to incidence (FALSE) before analysis. If not specified, default is TRUE.}

\item{na.rm}{Remove NA values before calculating cwm.}
}
\value{
A sites x trait matrix with mean value per site and trait.
}
\description{
Average value of each of a series of traits in multiple communities.
}
\details{
Community weighted mean is used to compare communities in terms of their "typical" trait values.
}
\examples{
comm <- matrix(c(2,5,0,0,0,1,1,0,0,0,0,1,2,0,0,0,0,0,10,1), nrow = 4, ncol = 5, byrow = TRUE)
rownames(comm) = c("Site1","Site2","Site3","Site4")
colnames(comm) = c("Sp1","Sp2","Sp3","Sp4","Sp5")
trait <- matrix(c(1,1,0,0,0,0,2,1,0,0,0,0,2,1,0,0,0,0,2,1), nrow = 5, ncol = 4, byrow = TRUE)
rownames(trait) = colnames(comm)
colnames(trait) = c("Trait1","Trait2","Trait3","Trait4")
cwm(comm, trait)
cwm(comm, trait, FALSE)
}
