% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cch.R
\name{phi1}
\alias{phi1}
\title{Compound Confluent hypergeometric function of two variables}
\usage{
phi1(a, b, c, x, y)
}
\arguments{
\item{a}{a > 0}

\item{b}{arbitrary}

\item{c}{c > 0}

\item{x}{x > 0}

\item{y}{0 <= y < 1}
}
\description{
Compute the Confluent Hypergeometric function of two variables, also know as
a Horn hypergeometric function or Humbert's hypergeometric used in Gordy
(1998) with integral representation:
}
\details{
phi_1(a,b,c,x,y) = Beta(a,b) Int_0^1
t^(a-1) (1 - t)^(c-a-1) (1 - yt)^(-b) exp(x t) dt
\url{https://en.wikipedia.org/wiki/Humbert_series} Note that Gordy's
arguments for x and y are reversed in the reference above.

Code for phi1 provided by Gordy.
}
\examples{

# special cases
# phi1(a, b, c, x=0, y) is the same as 2F1(b, a; c, y)
phi1(1, 2, 1.5, 0, 1 / 100)
hypergeometric2F1(2, 1, 1.5, 1 / 100, log = FALSE)

# phi1(a,0,c,x,y) is the same as 1F1(a,c,x)
phi1(1, 0, 1.5, 3, 1 / 100)
hypergeometric1F1(1, 1.5, 3, log = FALSE)
}
\references{
Gordy 1998
}
\seealso{
Other special functions: 
\code{\link{hypergeometric1F1}()},
\code{\link{hypergeometric2F1}()}
}
\author{
Merlise Clyde (\email{clyde@stat.duke.edu})
}
\concept{special functions}
\keyword{math}
