% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_diagnostics.R
\name{plot.angmcmc}
\alias{plot.angmcmc}
\title{Summary plots for angmcmc objects}
\usage{
\method{plot}{angmcmc}(x, par.name, comp.label, chain.no,
  do.paramtrace = TRUE, do.lpdtrace = TRUE, use.llik = FALSE, ...)
}
\arguments{
\item{x}{angmcmc object}

\item{par.name}{vector of names of parameters for which point estimates are to be computed.  If \code{NULL}, results for all parameters are provided.}

\item{comp.label}{vector of component labels (positive integers, e.g., \code{1, 2, ...}) for which point estimates are to be computed.
If \code{NULL}, results for all components are provided.}

\item{chain.no}{vector of chain numbers whose samples are to be be used.
in the estimation. By default all chains are used.}

\item{do.paramtrace}{logical. Should the trace(s) for the
parameter(s) be plotted?}

\item{do.lpdtrace}{logical. Should the log posterior trace
be plotted?}

\item{use.llik}{logical. Should the log likelihood be plotted
instead? Ignored if \code{do.lpdtrace == FALSE}.}

\item{...}{unused}
}
\description{
Summary plots for angmcmc objects
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
plot(fit.vmsin.20)
}
