% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_diagnostics.R
\name{densityplot1d}
\alias{densityplot1d}
\title{Density curve for angmcmc object with univariate data}
\usage{
densityplot1d(object, fn = mean, show.hist = TRUE, burnin = 1/3,
  thin = 1, ...)
}
\arguments{
\item{object}{angular MCMC object (with univariate data).}

\item{fn}{function to evaluate on MCMC samples to estimate parameters.  Defaults to \code{mean}, which computes the estimated posterior mean.}

\item{show.hist}{logical. Should a histogram for the data points be added to the plot?}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}

\item{...}{other arguments to be passed to the function \code{\link{hist}} from graphics. Ignored if
\code{show.hist == FALSE}.}
}
\description{
Density curve for angmcmc object with univariate data
}
\details{
To estimate the mixture density, first the parameter vector \eqn{\eta} is estimated
by applying \code{fn} on the MCMC samples, yielding the (consistent) Bayes estimate \eqn{\hat{\eta}}. Then the mixture density
\eqn{f(x|\eta)} at any point \eqn{x} is (consistently) estimated by \eqn{f(x|\hat{\eta})}.
}
\examples{
# first fit a vm mixture model
# illustration only - more iterations needed for convergence
fit.vm.20 <- fit_vmmix(wind, ncomp = 2, n.iter =  20,
                       ncores = 1)
# now create density curve with the default first 1/3 as burn-in and thin = 1
densityplot1d(fit.vm.20)

}
