% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportCSV.BCal.R
\name{ImportCSV.BCal}
\alias{ImportCSV.BCal}
\title{Importing a BCal csv file}
\usage{
ImportCSV.BCal(file, bin.width = NULL)
}
\arguments{
\item{file}{Name of the CSV file containing the output of the MCMC algorithm.}

\item{bin.width}{Bin width specified in a BCal project
(note: \code{bin.width} does not have to be set if the BCal default bin width of 1 is used).}
}
\value{
A data frame containing a representation of the data in the CSV file
}
\description{
Importing a csv file containing the output of the MCMC algorithm from the BCal software
}
\examples{
\dontrun{
  # Import of MCMC generated by BCal and extracted in cal BP (the year of reference is 1950)
  data(Fishpond)
  write.csv(Fishpond, "fishpond_MCMC.csv", row.names = FALSE)
  Fishpond = ImportCSV.BCal("fishpond_MCMC.csv", bin.width = 1)
}

\dontrun{
  # equivalent call
  Fishpond2 = ImportCSV("fishpond_MCMC.csv", dec = '.', sep=',', referenceYear = 1950,
                        rowToWithdraw = "last", bin.width = 1)
}
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Thomas S. Dye, \email{tsd@tsdye.online}, and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
